<?php
session_start();
require 'connection.php';

// Make sure user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','msg'=>'User not logged in']);
    exit;
}

// Get logged-in user ID
$agent_id = intval($_SESSION['user_id']);

// Get POST data
$data = $_POST;

// Handle contract file upload
$contract_file = '';
if (isset($_FILES['contract_file']) && !empty($_FILES['contract_file']['name'])) {
    $target_dir = "uploads/";
    $contract_file = time() . '_' . basename($_FILES['contract_file']['name']);
    if (!move_uploaded_file($_FILES['contract_file']['tmp_name'], $target_dir . $contract_file)) {
        echo json_encode(['status' => 'error', 'msg' => 'Failed to upload contract file']);
        exit;
    }
}

// Map POST keys to DB columns
$columns = [
    'company_name'       => 'company_name',
    'client_name'        => 'client_name',
    'mobile'             => 'mobile',
    'alt_mobile'         => 'alt_mobile',
    'email'              => 'email',
    'address'            => 'address',
    'total_price'        => 'total_price',
    'initial_pay'        => 'initial_pay',
    'pending_pay'        => 'pending_pay',
    'term_plan'          => 'term_plan',
    'project_start_date' => 'project_start_date',
    'project_end_date'   => 'project_end_date',
    'stage'              => 'stage',
    'assigned_to'        => 'assigned_to',
    'renewal_date'       => 'renewal_date',
    'renewal_cost'       => 'renewal_cost',
    'domain'             => 'domain',
    'hosting'            => 'hosting',
    'service'            => 'service',
    'business_type'      => 'business_type',
    'duration'           => 'duration',
    'agent_id'           => 'session_user' // use logged-in user
];

// Include contract_file if uploaded
if ($contract_file) {
    $columns['contract_file'] = 'contract_file';
}

// Build SQL
$dbCols = implode(',', array_keys($columns));
$placeholders = implode(',', array_fill(0, count($columns), '?'));
$sql = "INSERT INTO clients ($dbCols) VALUES ($placeholders)";

$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    echo json_encode(['status'=>'error','msg'=>mysqli_error($con)]);
    exit;
}

// Bind parameters dynamically
$types = '';
$values = [];
foreach ($columns as $db_col => $post_key) {
    if ($db_col === 'agent_id') {
        $values[] = $agent_id;
        $types .= 'i';
    } elseif (in_array($db_col, ['total_price','initial_pay','pending_pay','renewal_cost'])) {
        $values[] = isset($data[$post_key]) ? (float)$data[$post_key] : 0.0;
        $types .= 'd';
    } elseif ($db_col === 'contract_file') {
        $values[] = $contract_file;
        $types .= 's';
    } else {
        $values[] = $data[$post_key] ?? '';
        $types .= 's';
    }
}

// Bind params using references
$params = [];
$params[] = & $types;
foreach ($values as $k => $v) {
    $params[] = & $values[$k];
}
call_user_func_array([$stmt, 'bind_param'], $params);

// Execute
if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['status'=>'success','id'=>mysqli_insert_id($con)]);
} else {
    echo json_encode(['status'=>'error','msg'=>mysqli_stmt_error($stmt)]);
}
?>
