<?php
session_start();

$isLoggedIn = isset($_SESSION['user_id']);

$userName  = $_SESSION['user_name'] ?? '';
$userEmail = $_SESSION['user_email'] ?? '';
$userRole  = $_SESSION['role'] ?? '';
?>
<!doctype html>
<html class="no-js" lang="en" dir="ltr">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, shrink-to-fit=no"
    />
    <title>:: My-Task: Client Data</title>
    <link rel="icon" href="favicon.ico" type="image/x-icon" />
    <!-- Favicon-->
    <link
      rel="stylesheet"
      href="assets/plugin/datatables/responsive.dataTables.min.css"
    />
    <link
      rel="stylesheet"
      href="assets/plugin/datatables/dataTables.bootstrap5.min.css"
    />

    <!-- project css file  -->
    <link rel="stylesheet" href="assets/css/my-task.style.min.css" />
    <style>
      /* Compact form styling for Lead Contact and Company Details */
      .add-client h4 {
        font-size: 16px;
        font-weight: 600;
        padding: 12px 20px;
        margin-bottom: 0;
      }
      .add-client .f-14,
      .add-client label,
      .add-client .form-check-label {
        font-size: 13px !important;
        color: #495057;
      }
      .add-client .form-group {
        margin-bottom: 10px;
      }
      .add-client .form-control {
        height: 38px;
        font-size: 13px;
        padding: 6px 10px;
        border-radius: 6px;
      }
      .add-client .input-group-text {
        font-size: 13px;
      }
      .add-client .form-check-input {
        width: 18px;
        height: 18px;
      }
      .add-client .row.p-20 {
        padding: 12px;
      }
      .add-client .border-top-grey {
        border-top: 1px solid #e9ecef;
      }

      /* View modal compact rows */
      #viewLeadBody .text-muted {
        font-size: 13px;
      }
      #viewLeadBody .fw-bold {
        font-size: 14px;
      }
      #viewLeadBody h6 {
        font-size: 15px;
        margin-top: 6px;
      }

      /* Make modal slightly tighter */
      .modal-lg .modal-body {
        padding: 16px 20px;
      }

      /* Responsive tweaks */
      @media (max-width: 576px) {
        .add-client .form-control {
          height: 42px;
        }
        .add-client h4 {
          font-size: 15px;
        }
      }
    </style>
  </head>
  <body data-mytask="theme-indigo">
    <div id="mytask-layout">
      <!-- sidebar -->
      <div class="sidebar px-4 py-4 py-md-5 me-0">
        <div class="d-flex flex-column h-100">
          <a href="index-2.html" class="mb-0 brand-icon">
            <span class="logo-icon">
              <svg
                width="35"
                height="35"
                fill="currentColor"
                class="bi bi-clipboard-check"
                viewBox="0 0 16 16"
              >
                <path
                  fill-rule="evenodd"
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z"
                />
                <path
                  d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"
                />
                <path
                  d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"
                />
              </svg>
            </span>
            <span class="logo-text">My-Task</span>
          </a>
          <!-- Menu: main ul -->
          <ul class="menu-list flex-grow-1 mt-3">
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#dashboard-Components"
                href="#"
              >
                <i class="icofont-home fs-5"></i> <span>Dashboard</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="dashboard-Components">
                <li>
                  <a class="ms-link" href="index-2.html">
                    <span>Hr Dashboard</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="project-dashboard.html">
                    <span>Project Dashboard</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#project-Components"
                href="#"
              >
                <i class="icofont-briefcase"></i><span>Projects</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="project-Components">
                <li>
                  <a class="ms-link" href="projects.html"
                    ><span>Projects</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="task.html"><span>Tasks</span></a>
                </li>
                <li>
                  <a class="ms-link" href="timesheet.html"
                    ><span>Timesheet</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="team-leader.html"
                    ><span>Leaders</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link active"
                data-bs-toggle="collapse"
                data-bs-target="#leads-Components"
                href="#"
              >
                <i class="icofont-users"></i><span>Leads</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse show" id="leads-Components">
                <li>
                  <a class="ms-link" href="deals.php"
                    ><span>Sales Report</span></a
                  >
                </li>
                <li>
                  <a class="ms-link active" href="lead-contact.php"
                    ><span>Client Data</span></a
                  >
                </li>
              </ul>
            </li>

            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#tikit-Components"
                href="#"
                ><i class="icofont-ticket"></i> <span>Tickets</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="tikit-Components">
                <li>
                  <a class="ms-link" href="tickets.html">
                    <span>Tickets View</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="ticket-detail.html">
                    <span>Ticket Detail</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#client-Components"
                href="#"
                ><i class="icofont-user-male"></i> <span>Our Clients</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="client-Components">
                <li>
                  <a class="ms-link" href="ourclients.html">
                    <span>Clients</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="profile.html">
                    <span>Client Profile</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#emp-Components"
                href="#"
                ><i class="icofont-users-alt-5"></i> <span>Employees</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="emp-Components">
                <li>
                  <a class="ms-link" href="members.html">
                    <span>Members</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="employee-profile.html">
                    <span>Members Profile</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="holidays.html">
                    <span>Holidays</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="attendance-employees.html">
                    <span>Attendance Employees</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="attendance.html">
                    <span>Attendance</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="leave-request.html">
                    <span>Leave Request</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="department.html">
                    <span>Department</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="loan.html"> <span>Loan</span></a>
                </li>
              </ul>
            </li>

            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#menu-Componentsone"
                href="#"
                ><i class="icofont-ui-calculator"></i> <span>Accounts</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="menu-Componentsone">
                <li>
                  <a class="ms-link" href="invoices.html"
                    ><span>Invoices</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="payments.html"
                    ><span>Payments</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="expenses.html"
                    ><span>Expenses</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="create-invoice.html"
                    ><span>Create Invoice</span>
                  </a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#payroll-Components"
                href="#"
                ><i class="icofont-users-alt-5"></i> <span>Payroll</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="payroll-Components">
                <li>
                  <a class="ms-link" href="salaryslip.html"
                    ><span>Employee Salary</span>
                  </a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#app-Components"
                href="#"
              >
                <i class="icofont-contrast"></i> <span>App</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="app-Components">
                <li>
                  <a class="ms-link" href="calendar.html">
                    <span>Calander</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="chat.html"><span>Chat App</span></a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#extra-Components"
                href="#"
              >
                <i class="icofont-code-alt"></i> <span>Other Pages</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="extra-Components">
                <li>
                  <a class="ms-link" href="charts.html">
                    <span>Apex Charts</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="forms.html"
                    ><span>Forms Example</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="table.html">
                    <span>Table Example</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="review.html"
                    ><span>Reviews Page</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="icon.html"><span>Icons</span></a>
                </li>
                <li>
                  <a class="ms-link" href="contact.html"
                    ><span>Contact</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="widgets.html"
                    ><span>Widgets</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="todo-list.html"
                    ><span>Todo-List</span></a
                  >
                </li>
              </ul>
            </li>
            <li>
              <a class="m-link" href="ui-elements/ui-alerts.html"
                ><i class="icofont-paint"></i> <span>UI Components</span></a
              >
            </li>
          </ul>

          <!-- Menu: menu collepce btn -->
          <button
            type="button"
            class="btn btn-link sidebar-mini-btn text-light"
          >
            <span class="ms-2"><i class="icofont-bubble-right"></i></span>
          </button>
        </div>
      </div>

      <!-- main body area -->
      <div class="main px-lg-4 px-md-4">
        <!-- Body: Header -->
        <div class="header">
          <nav class="navbar py-4">
            <div class="container-xxl">
              <!-- header rightbar icon -->
              <div
                class="h-right d-flex align-items-center mr-5 mr-lg-0 order-1"
              >
                <div class="d-flex">
                  <a
                    class="nav-link text-primary collapsed"
                    href="help.html"
                    title="Get Help"
                  >
                    <i class="icofont-info-square fs-5"></i>
                  </a>
                  <div class="avatar-list avatar-list-stacked px-3">
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar2.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar1.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar3.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar4.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar7.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar8.jpg"
                      alt=""
                    />
                    <span
                      class="avatar rounded-circle text-center pointer"
                      data-bs-toggle="modal"
                      data-bs-target="#addUser"
                      ><i class="icofont-ui-add"></i
                    ></span>
                  </div>
                </div>
                <div class="dropdown notifications">
                  <a
                    class="nav-link dropdown-toggle pulse"
                    href="#"
                    role="button"
                    data-bs-toggle="dropdown"
                  >
                    <i class="icofont-alarm fs-5"></i>
                    <span class="pulse-ring"></span>
                  </a>
                  <div
                    id="NotificationsDiv"
                    class="dropdown-menu rounded-lg shadow border-0 dropdown-animation dropdown-menu-sm-end p-0 m-0"
                  >
                    <div class="card border-0 w380">
                      <div class="card-header border-0 p-3">
                        <h5
                          class="mb-0 font-weight-light d-flex justify-content-between"
                        >
                          <span>Notifications</span>
                          <span class="badge text-white">11</span>
                        </h5>
                      </div>
                      <div class="tab-content card-body">
                        <div class="tab-pane fade show active">
                          <ul class="list-unstyled list mb-0">
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle"
                                  src="assets/images/xs/avatar1.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Shalini</span
                                    >
                                    <small>2MIN</small>
                                  </p>
                                  <span class=""
                                    >Added 2021-02-19 my-Task ui/ux Design
                                    <span class="badge bg-success"
                                      >Review</span
                                    ></span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <div class="avatar rounded-circle no-thumbnail">
                                  DF
                                </div>
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Diane Fisher</span
                                    >
                                    <small>13MIN</small>
                                  </p>
                                  <span class=""
                                    >Task added Get Started with Fast Cad
                                    project</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar3.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Andrea Gill</span
                                    >
                                    <small>1HR</small>
                                  </p>
                                  <span class=""
                                    >Quality Assurance Task Completed</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar5.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Diane Fisher</span
                                    >
                                    <small>13MIN</small>
                                  </p>
                                  <span class=""
                                    >Add New Project for App Developemnt</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar6.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Andrea Gill</span
                                    >
                                    <small>1HR</small>
                                  </p>
                                  <span class=""
                                    >Add Timesheet For Rhinestone project</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar7.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Zoe Wright</span
                                    >
                                    <small class="">1DAY</small>
                                  </p>
                                  <span class="">Add Calander Event</span>
                                </div>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </div>
                      <a class="card-footer text-center border-top-0" href="#">
                        View all notifications</a
                      >
                    </div>
                  </div>
                </div>
                          <div class="dropdown user-profile ml-2 ml-sm-3 d-flex align-items-center">

    <?php if ($isLoggedIn): ?>
        <!-- User Info -->
        <div class="u-info me-2">
            <p class="mb-0 text-end line-height-sm">
                <span class="font-weight-bold">
                    <?php echo htmlspecialchars($userName); ?>

                </span>
            </p>
            <small><?php echo htmlspecialchars($userRole); ?> Profile</small>
        </div>
    <?php endif; ?>

    <a class="nav-link dropdown-toggle pulse p-0" href="#" role="button"
       data-bs-toggle="dropdown" data-bs-display="static">
        <img class="avatar lg rounded-circle img-thumbnail"
             src="assets/images/profile_av.png" alt="profile">
    </a>

    <div class="dropdown-menu rounded-lg shadow border-0 dropdown-animation dropdown-menu-end p-0 m-0">
        <div class="card border-0 w280">

            <?php if ($isLoggedIn): ?>
                <!-- Logged-in User Details -->
                <div class="card-body pb-0">
                    <div class="d-flex py-1">
                        <img class="avatar rounded-circle"
                             src="assets/images/profile_av.png" alt="profile">

                        <div class="flex-fill ms-3">
                            <p class="mb-0">
                                <span class="font-weight-bold">
                                   <?php echo htmlspecialchars($userName); ?>

                                </span>
                            </p>
                            <small>
                                <?php echo htmlspecialchars($userEmail); ?>

                            </small>
                        </div>
                    </div>
                    <hr class="dropdown-divider border-dark">
                </div>

                <!-- Logged-in Menu -->
                <div class="list-group m-2">
                   <!--  <a href="task.html" class="list-group-item list-group-item-action border-0">
                        <i class="icofont-tasks fs-5 me-3"></i>My Task
                    </a>

                    <a href="members.html" class="list-group-item list-group-item-action border-0">
                        <i class="icofont-ui-user-group fs-6 me-3"></i>Members
                    </a> -->

                    <a href="logout.php" class="list-group-item list-group-item-action border-0 text-danger">
                        <i class="icofont-logout fs-6 me-3"></i>Logout
                    </a>
                </div>

            <?php else: ?>
                <!-- Guest Menu -->
                <div class="list-group m-2">
                    <a href="ui-elements/auth-signin.php"
                       class="list-group-item list-group-item-action border-0">
                        <i class="icofont-login fs-6 me-3"></i>Login
                    </a>

                    <a href="ui-elements/auth-signup.php"
                       class="list-group-item list-group-item-action border-0">
                        <i class="icofont-contact-add fs-5 me-3"></i>Sign Up
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>

                <div class="px-md-1">
                  <a
                    href="#offcanvas_setting"
                    data-bs-toggle="offcanvas"
                    aria-expanded="false"
                    title="template setting"
                  >
                    <svg
                      class="svg-stroke"
                      xmlns="http://www.w3.org/2000/svg"
                      width="22"
                      height="22"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                      fill="none"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    >
                      <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                      <path
                        d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"
                      ></path>
                      <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                    </svg>
                  </a>
                </div>
              </div>

              <!-- menu toggler -->
              <button
                class="navbar-toggler p-0 border-0 menu-toggle order-3"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#mainHeader"
              >
                <span class="fa fa-bars"></span>
              </button>

              <!-- main menu Search-->
              <div
                class="order-0 col-lg-4 col-md-4 col-sm-12 col-12 mb-3 mb-md-0"
              >
                <div class="input-group flex-nowrap input-group-lg">
                  <button
                    type="button"
                    class="input-group-text"
                    id="addon-wrapping"
                  >
                    <i class="fa fa-search"></i>
                  </button>
                  <input
                    type="search"
                    class="form-control"
                    placeholder="Search"
                    aria-label="search"
                    aria-describedby="addon-wrapping"
                  />
                  <button
                    type="button"
                    class="input-group-text add-member-top"
                    id="addon-wrappingone"
                    data-bs-toggle="modal"
                    data-bs-target="#addUser"
                  >
                    <i class="fa fa-plus"></i>
                  </button>
                </div>
              </div>
            </div>
          </nav>
        </div>

        <!-- Body: Body -->
        <div class="body d-flex py-lg-3 py-md-2">
          <div class="container-xxl">
            <div class="row align-items-center">
              <div class="border-0 mb-4">
                <div
                  class="card-header py-3 no-bg bg-transparent d-flex align-items-center px-0 justify-content-between border-bottom flex-wrap"
                >
                  <h3 class="fw-bold mb-0">Client Data</h3>
                  <div class="col-auto d-flex w-sm-100">
                    <button
                      id="addDealBtn"
                      class="btn btn-primary"
                      data-bs-toggle="modal"
                      data-bs-target="#leadModal"
                    >
                      <i class="icofont-plus-circle me-2"></i>Add New Deal
                    </button>
                  </div>
                </div>
              </div>
            </div>
            <div class="row clearfix g-3">
              <div class="col-sm-12">
                <div class="card mb-3">
                  <div class="card-body">
                    <div class="table-responsive">
                      <table
                        id="leadcontact"
                        class="table table-hover align-middle"
                      >
                        <thead>
                          <tr>
                            <th>Client Company Name</th>
                            <th>Client Name</th>
                            <th>Mobile</th>
                            <th>Email</th>
                            <th>Alt Mobile</th>
                            <th>Call Date</th>

                            <th>Business Type</th>
                            <th>Call Status</th>
                            <th>Follow Up</th>
                            <th>Meeting Schedule</th>
                            <th>Meeting Mode</th>
                            <th>Expected Closure</th>
                            <th>Proposal / Contract</th>
                            <th>Proposal PDF</th>
                            <th>Contract PDF</th>

                            <th>Service</th>
                            <th>Duration</th>
                            <th>Meeting State</th>
                             <th>Client State</th>

                            <th class="text-end">Action</th>
                            <th>Agent</th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Add / Edit Lead Contact -->
            <div
              class="modal fade"
              id="leadModal"
              tabindex="-1"
              aria-labelledby="leadModalLabel"
              aria-hidden="true"
            >
              <div class="modal-dialog modal-xl modal-dialog-centered">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title fw-bold" id="leadModalLabel">
                      Add Lead Contact
                    </h5>
                    <button
                      type="button"
                      class="btn-close"
                      data-bs-dismiss="modal"
                      aria-label="Close"
                    ></button>
                  </div>
                  <div class="modal-body">
                    <div class="add-client bg-white rounded">
                      <h4
                        class="mb-0 p-20 f-21 font-weight-normal border-bottom-grey"
                      >
                        Lead Contact Detail
                      </h4>

                      <div class="row p-20" id="deal_form">
                        <div class="col-lg-4 col-md-6">
                          <label>Client Name *</label>
                          <input
                            type="text"
                            id="client_name"
                            class="form-control"
                          />
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Mobile *</label>
                          <input type="tel" id="mobile" class="form-control" />
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Email</label>
                          <input
                            type="email"
                            id="client_email"
                            class="form-control"
                          />
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Alt Mobile</label>
                          <input
                            type="tel"
                            id="alt_mobile"
                            class="form-control"
                          />
                        </div>
                        <div class="col-lg-4 col-md-6">
  <label>Company Name *</label>
  <input type="text" id="company_name" class="form-control" />
</div>


                        <div class="col-lg-4 col-md-6">
                          <label>Call Date</label>
                          <input
                            type="date"
                            id="call_date"
                            class="form-control"
                          />
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Business Type</label>
                          <select id="business_type" class="form-control">
                            <option>Manufacturer</option>
                            <option>Retail</option>
                            <option>Both</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Call Status</label>
                          <select id="call_status" class="form-control">
                            <option>Connected</option>
                            <option>Not Connected</option>
                            <option>Busy</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Follow Up Date & Time</label>
                          <input
                            type="datetime-local"
                            id="follow_up"
                            class="form-control"
                          />
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Meeting Scheduled?</label>
                          <select id="meeting_schedule" class="form-control">
                            <option>Yes</option>
                            <option>No</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Meeting Mode</label>
                          <select id="meeting_mode" class="form-control">
                            <option>Online</option>
                            <option>Offline</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Expected Closure Date</label>
                          <input
                            type="date"
                            id="expected_closure"
                            class="form-control"
                          />
                        </div>
                        <div class="col-lg-4 col-md-6">
                          <label>Proposal / Contract</label>
                          <select id="proposal_status" class="form-control">
                            <option>Sent</option>
                            <option>Not Sent</option>
                          </select>
                        </div>
<div class="col-lg-4 col-md-6">
  <label>Proposal File</label>
  <input type="file" id="proposal_file" class="form-control" />
  <small id="proposal_preview"></small>
</div>

<div class="col-lg-4 col-md-6">
  <label>Contract File</label>
  <input type="file" id="contract_file" class="form-control" />
  <small id="contract_preview"></small>
</div>

                        <div class="col-lg-4 col-md-6">
                          <label>Meeting State</label>
                          <select id="meeting_state" class="form-control">
                            <option>Done</option>
                            <option>Pending</option>
                            <option>Cancelled</option>
                          </select>
                        </div>
                         <div class="col-lg-4 col-md-6">
                          <label>Client State</label>
                          <select id="meeting_state" class="form-control">
                            <option>Done</option>
                            <option>Pending</option>
                            <option>Cancelled</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Service</label>
                          <select id="service" class="form-control">
                            <option>Static Website</option>
                            <option>Dynamic Website</option>
                            <option>SEO</option>
                            <option>Social Media</option>
                          </select>
                        </div>

                        <div class="col-lg-4 col-md-6">
                          <label>Duration</label>
                          <select id="duration" class="form-control">
                            <option>1 Month</option>
                            <option>6 Months</option>
                            <option>1 Year</option>
                          </select>
                        </div>
                      <?php
include 'connection.php';

$logged_in_user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Fetch agents
$agents = [];
if ($role === 'Admin') {
    $result = $con->query("SELECT id, name FROM users WHERE role='Agent' AND status=1");
} else {
    $stmt = $con->prepare("SELECT id, name FROM users WHERE id=? AND status=1");
    $stmt->bind_param("i", $logged_in_user_id);
    $stmt->execute();
    $result = $stmt->get_result();
}

while ($row = $result->fetch_assoc()) {
    $agents[] = $row;
}
?>

<div class="col-lg-4 col-md-6">
    <label>Deal Agent</label>
    <select id="deal_agent_id" class="form-control" name="deal_agent_id"
        <?= ($role !== 'Admin') ? 'disabled' : '' ?>>

        <?php foreach ($agents as $agent): ?>
            <option value="<?= $agent['id'] ?>">
                <?= htmlspecialchars($agent['name']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<?php if ($role !== 'Admin'): ?>
    <!-- ensure value is submitted when disabled -->
    <input type="hidden" id="deal_agent_hidden" value="<?= $logged_in_user_id ?>">
<?php endif; ?>


                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button
                      type="button"
                      class="btn btn-primary"
                      id="save-deal-form"
                    >
                      Save
                    </button>

                    <button
                      type="button"
                      class="btn btn-light"
                      data-bs-dismiss="modal"
                    >
                      Cancel
                    </button>
                  </div>
                </div>
              </div>
            </div>

            <!-- View Deal Modal -->
            <div
              class="modal fade"
              id="viewLeadModal"
              tabindex="-1"
              aria-hidden="true"
            >
              <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Lead Details</h5>
                    <button
                      type="button"
                      class="btn-close"
                      data-bs-dismiss="modal"
                      aria-label="Close"
                    ></button>
                  </div>
                  <div class="modal-body" id="viewLeadBody"></div>
                </div>
              </div>
            </div>

            <!-- Confirm Delete Modal -->
            <div
              class="modal fade"
              id="confirmDeleteModal"
              tabindex="-1"
              aria-hidden="true"
            >
              <div class="modal-dialog modal-sm modal-dialog-centered">
                <div class="modal-content">
                  <div class="modal-body text-center p-4">
                    <p class="mb-3">
                      Are you sure you want to delete this lead?
                    </p>
                    <div class="d-flex justify-content-center gap-2">
                      <button
                        type="button"
                        class="btn btn-danger"
                        id="confirmDeleteBtn"
                      >
                        Delete
                      </button>
                      <button
                        type="button"
                        class="btn btn-secondary"
                        data-bs-dismiss="modal"
                      >
                        Cancel
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal Members-->
        <div
          class="modal fade"
          id="addUser"
          tabindex="-1"
          aria-labelledby="addUserLabel"
          aria-hidden="true"
        >
          <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title fw-bold" id="addUserLabel">
                  Employee Invitation
                </h5>
                <button
                  type="button"
                  class="btn-close"
                  data-bs-dismiss="modal"
                  aria-label="Close"
                ></button>
              </div>
              <div class="modal-body">
                <div class="inviteby_email">
                  <div class="input-group mb-3">
                    <input
                      type="email"
                      class="form-control"
                      placeholder="Email address"
                      id="exampleInputEmail1"
                      aria-describedby="exampleInputEmail1"
                    />
                    <button
                      class="btn btn-dark"
                      type="button"
                      id="button-addon2"
                    >
                      Sent
                    </button>
                  </div>
                </div>
                <div class="members_list">
                  <h6 class="fw-bold">Employee</h6>
                  <ul
                    class="list-unstyled list-group list-group-custom list-group-flush mb-0"
                  >
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar2.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">Rachel Carr(you)</h6>
                          <span class="text-muted">rachel.carr@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <span class="members-role">Admin</span>
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              <i class="icofont-ui-settings fs-6"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-ui-password fs-6 me-2"></i
                                  >ResetPassword</a
                                >
                              </li>
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-chart-line fs-6 me-2"></i
                                  >ActivityReport</a
                                >
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar3.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">
                            Lucas Baker<a href="#" class="link-secondary ms-2"
                              >(Resend invitation)</a
                            >
                          </h6>
                          <span class="text-muted">lucas.baker@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              Members
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="icofont-check-circled"></i>

                                  <span>All operations permission</span>
                                </a>
                              </li>
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="fs-6 p-2 me-1"></i>
                                  <span>Only Invite & manage team</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              <i class="icofont-ui-settings fs-6"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-delete-alt fs-6 me-2"></i
                                  >Delete Member</a
                                >
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar8.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">Una Coleman</h6>
                          <span class="text-muted">una.coleman@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              Members
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="icofont-check-circled"></i>

                                  <span>All operations permission</span>
                                </a>
                              </li>
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="fs-6 p-2 me-1"></i>
                                  <span>Only Invite & manage team</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                          <div class="btn-group">
                            <div class="btn-group">
                              <button
                                type="button"
                                class="btn bg-transparent dropdown-toggle"
                                data-bs-toggle="dropdown"
                                aria-expanded="false"
                              >
                                <i class="icofont-ui-settings fs-6"></i>
                              </button>
                              <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i
                                      class="icofont-ui-password fs-6 me-2"
                                    ></i
                                    >ResetPassword</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i class="icofont-chart-line fs-6 me-2"></i
                                    >ActivityReport</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i class="icofont-delete-alt fs-6 me-2"></i
                                    >Suspend member</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i
                                      class="icofont-not-allowed fs-6 me-2"
                                    ></i
                                    >Delete Member</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- start: template setting, and more. -->
      <div
        class="offcanvas offcanvas-end"
        tabindex="-1"
        id="offcanvas_setting"
        aria-labelledby="offcanvas_setting"
      >
        <div class="offcanvas-header">
          <h5 class="offcanvas-title">Template Setting</h5>
          <button
            type="button"
            class="btn-close"
            data-bs-dismiss="offcanvas"
            aria-label="Close"
          ></button>
        </div>
        <div class="offcanvas-body d-flex flex-column">
          <div class="mb-4">
            <h6>Set Theme Color</h6>
            <ul class="choose-skin list-unstyled mb-0">
              <li data-theme="ValenciaRed">
                <div style="--mytask-theme-color: #d63b38"></div>
              </li>
              <li data-theme="SunOrange">
                <div style="--mytask-theme-color: #f7a614"></div>
              </li>
              <li data-theme="AppleGreen">
                <div style="--mytask-theme-color: #5bc43a"></div>
              </li>
              <li data-theme="CeruleanBlue">
                <div style="--mytask-theme-color: #00b8d6"></div>
              </li>
              <li data-theme="Mariner">
                <div style="--mytask-theme-color: #0066fe"></div>
              </li>
              <li data-theme="PurpleHeart" class="active">
                <div style="--mytask-theme-color: #6238b3"></div>
              </li>
              <li data-theme="FrenchRose">
                <div style="--mytask-theme-color: #eb5393"></div>
              </li>
            </ul>
          </div>
          <div class="mb-4 flex-grow-1">
            <h6>Set Theme Light/Dark/RTL</h6>
            <!-- Theme: Switch Theme -->
            <ul class="list-unstyled mb-0">
              <li>
                <div class="form-check form-switch theme-switch">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="theme-switch"
                  />
                  <label class="form-check-label mx-2" for="theme-switch"
                    >Enable Dark Mode!</label
                  >
                </div>
              </li>
              <li>
                <div class="form-check form-switch theme-rtl">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="theme-rtl"
                  />
                  <label class="form-check-label mx-2" for="theme-rtl"
                    >Enable RTL Mode!</label
                  >
                </div>
              </li>
              <li>
                <div class="form-check form-switch monochrome-toggle">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="monochrome"
                  />
                  <label class="form-check-label mx-2" for="monochrome"
                    >Monochrome Mode</label
                  >
                </div>
              </li>
            </ul>
          </div>
          <div class="d-flex">
            <a
              href="https://themeforest.net/item/mytask-hr-project-management-admin-template/31974551"
              class="btn w-100 me-1 py-2 btn-primary"
              >Buy Now</a
            >
            <a
              href="https://themeforest.net/user/pixelwibes/portfolio"
              class="btn w-100 ms-1 py-2 btn-dark"
              >View Portfolio</a
            >
          </div>
        </div>
      </div>
    </div>

    <!-- Jquery Core Js -->
    <script src="assets/bundles/libscripts.bundle.js"></script>

    <!-- Plugin Js-->
    <script src="assets/bundles/dataTables.bundle.js"></script>

    <!-- Jquery Page Js -->
    <script src="../js/template.js"></script>

   <script>
(function() {
    var leads = [];
    var dt = null;
    var duration_map_rev = {1: "1 Month", 6: "6 Months", 12: "1 Year"};

 
function render() {
   var rows = leads.map((l) => [
    l.company_name||"--",
    l.client_name||"--",
    l.mobile||"--",
    l.client_email||"--",
    l.alt_mobile||"--",
    l.call_date||"--",
    l.business_type||"--",
    l.call_status||"--",
    l.follow_up||"--",
    l.meeting_schedule ? "Yes" : "No",
    l.meeting_mode||"--",
    l.expected_closure||"--",
    l.proposal_contract||"--",
    l.proposal_file ? `<a href="${l.proposal_file}" target="_blank">View</a>` : "--",
    l.contract_file ? `<a href="${l.contract_file}" target="_blank">View</a>` : "--",
    l.service||"--",
    duration_map_rev[l.duration]||"--",
    l.meeting_state||"--",
    l.client_done||"--",
    actionDropdown(l.id,l.client_id),
    l.agent_text||"--"
]);

    if(dt){
        dt.clear().rows.add(rows).draw(false);
    } else {
        dt = $("#leadcontact").DataTable({
            data: rows,
            responsive:true,
            ordering:false,
            pageLength:10,
            columnDefs:[{targets:16,orderable:false,className:"text-end"}]
        });
    }
}

function loadLeads(){
    $.getJSON("load_leads.php", function(data){
    if(data.error){
        alert("Error: " + data.error);
        return;
    }
    leads = data;
    render();
}).fail(function(xhr){
    alert("Failed to load leads: " + xhr.responseText);
});

}



    function actionDropdown(callId, clientId) {
        return `<div class="dropdown">
            <button class="btn btn-sm btn-light dropdown-toggle" data-bs-toggle="dropdown">Action</button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item action-item" data-action="edit" data-id="${callId}"> Edit </a></li>
                <li><a class="dropdown-item action-item" data-action="view" data-id="${callId}"> View </a></li>
                <li><a class="dropdown-item action-item" data-action="delete" data-id="${callId}"> Delete </a></li>
            </ul>
        </div>`;
    }

    function loadLeads() {
        $.ajax({
            url: "load_leads.php",
            type: "GET",
            dataType: "json",
            success: function(data) {
                leads = data;
                render();
            }
        });
    }

    function findLead(id) {
        return leads.find((x) => x.id == id);
    }

    function openEdit(id) {
        var l = id ? findLead(id) : {};
        $("#leadModal").data("editingId", id || null);

        $("#client_name").val(l.client_name || "");
        $("#mobile").val(l.mobile || "");
        $("#company_name").val(l.company_name || "");
        $("#client_email").val(l.client_email || "");
        $("#alt_mobile").val(l.alt_mobile || "");
        $("#remarks").val(l.remarks || "");
        $("#call_date").val(l.call_date ? l.call_date.split(' ')[0] : "");
        $("#business_type").val(l.business_type || "Manufacturer");
        $("#call_status").val(l.call_status || "Connected");
        $("#follow_up").val(l.follow_up ? l.follow_up.replace(' ', 'T') : "");
        $("#meeting_schedule").val(l.meeting_schedule ? "Yes" : "No");
        $("#meeting_mode").val(l.meeting_mode || "Online");
        $("#expected_closure").val(l.expected_closure || "");
        $("#proposal_status").val(l.proposal_contract === "Proposal" ? "Sent" : "Not Sent");
        $("#meeting_state").val(l.meeting_state || "Pending");
        $("#service").val(l.service || "Static Website");
        $("#duration").val(duration_map_rev[l.duration] || "1 Month");
       if (l.agent_id) {
    $("#deal_agent_id").val(l.agent_id);
}


        $("#proposal_preview").html(l.proposal_file ? `<a href="${l.proposal_file}" target="_blank">View</a>` : '');
        $("#contract_preview").html(l.contract_file ? `<a href="${l.contract_file}" target="_blank">View</a>` : '');

        $("#leadModal").modal("show");
    }

    function showView(id) {
        var l = findLead(id);
        if (!l) return;

        const show = (v) => (v === null || v === "" ? "--" : v);

        $("#viewLeadBody").html(`
            <div class="row g-3">
                <div class="col-md-6"><p><b>Company Name:</b> ${show(l.company_name)}</p></div>
                <div class="col-md-6"><p><b>Client Name:</b> ${show(l.client_name)}</p></div>
                <div class="col-md-6"><p><b>Mobile:</b> ${show(l.mobile)}</p></div>
                <div class="col-md-6"><p><b>Alt Mobile:</b> ${show(l.alt_mobile)}</p></div>
                <div class="col-md-6"><p><b>Email:</b> ${show(l.client_email)}</p></div>
                <div class="col-md-6"><p><b>Business Type:</b> ${show(l.business_type)}</p></div>
                <div class="col-md-6"><p><b>Call Date:</b> ${show(l.call_date)}</p></div>
                <div class="col-md-6"><p><b>Call Status:</b> ${show(l.call_status)}</p></div>
                <div class="col-md-6"><p><b>Follow Up:</b> ${show(l.follow_up)}</p></div>
                <div class="col-md-6"><p><b>Meeting Scheduled:</b> ${l.meeting_schedule ? "Yes" : "No"}</p></div>
                <div class="col-md-6"><p><b>Meeting Mode:</b> ${show(l.meeting_mode)}</p></div>
                <div class="col-md-6"><p><b>Meeting State:</b> ${show(l.meeting_state)}</p></div>
                <div class="col-md-6"><p><b>Expected Closure:</b> ${show(l.expected_closure)}</p></div>
                <div class="col-md-6"><p><b>Proposal / Contract:</b> ${show(l.proposal_contract)}</p></div>
                <div class="col-md-6"><p><b>Proposal File:</b> ${l.proposal_file ? `<a href="${l.proposal_file}" target="_blank">View</a>` : "--"}</p></div>
                <div class="col-md-6"><p><b>Contract File:</b> ${l.contract_file ? `<a href="${l.contract_file}" target="_blank">View</a>` : "--"}</p></div>
                <div class="col-md-6"><p><b>Service:</b> ${show(l.service)}</p></div>
                <div class="col-md-6"><p><b>Duration:</b> ${show(duration_map_rev[l.duration])}</p></div>
                <div class="col-md-6"><p><b>Remarks:</b> ${show(l.remarks)}</p></div>
                <div class="col-md-6"><p><b>Deal Agent:</b> ${show(l.agent_text)}</p></div>
                <div class="col-md-6"><p><b>Lead ID:</b> ${show(l.id)}</p></div>
            </div>
        `);

        $("#viewLeadModal").modal("show");
    }

    $(function() {
        loadLeads();

        $(document).on("click", ".action-item", function() {
            var id = $(this).data("id");
            var act = $(this).data("action");
            if (act === "edit") openEdit(id);
            if (act === "view") showView(id);
            if (act === "delete") {
                if (!confirm("Are you sure you want to delete this deal?")) return;

                $.ajax({
                    url: "delete_lead.php",
                    type: "POST",
                    data: { id: id },
                    dataType: "json",
                    success: function(resp) {
                        alert(resp.message);
                        if (resp.status === "success") loadLeads();
                    },
                    error: function(xhr) {
                        alert("Error deleting deal: " + xhr.responseText);
                    }
                });
            }
        });

       
        $("#addDealBtn").on("click", function () {
    $("#leadModal").removeData("editingId");
    $("#leadModal").find("input, select, textarea").val("");
$("#proposal_preview, #contract_preview").html('');
    // auto-select logged in agent
    $("#deal_agent_id").val("<?= $_SESSION['user_id'] ?>");
});


        $("#save-deal-form").click(function() {
            // Validation
            var client_name = $("#client_name").val().trim();
            var mobile = $("#mobile").val().trim();
            if (!client_name) { alert("Client Name is required."); return; }
            if (!mobile) { alert("Mobile is required."); return; }

            var id = $("#leadModal").data("editingId");
            var duration_map = {"1 Month": 1, "6 Months": 6, "1 Year": 12};
            var formData = new FormData();

            formData.append("client_name", client_name);
            formData.append("mobile", mobile);
            formData.append("client_email", $("#client_email").val());
            formData.append("alt_mobile", $("#alt_mobile").val());
            formData.append("company_name", $("#company_name").val());
            formData.append("remarks", $("#remarks").val());
            formData.append("call_date", $("#call_date").val() ? $("#call_date").val()+" 09:00:00" : "");
            formData.append("business_type", $("#business_type").val());
            formData.append("call_status", $("#call_status").val());
            formData.append("follow_up", $("#follow_up").val());
            formData.append("meeting_schedule", $("#meeting_schedule").val());
            formData.append("meeting_mode", $("#meeting_mode").val());
            formData.append("expected_closure", $("#expected_closure").val());
            formData.append("proposal_status", $("#proposal_status").val());
            formData.append("meeting_state", $("#meeting_state").val());
            formData.append("service", $("#service").val());
            formData.append("duration", $("#duration").val());
            formData.append("deal_agent_id", $("#deal_agent_id").val());
            formData.append("call_id", id || "");
            formData.append("client_id", $("#leadModal").data("clientId") || "");
            if ($("#proposal_file")[0].files[0]) formData.append("proposal_file", $("#proposal_file")[0].files[0]);
            if ($("#contract_file")[0].files[0]) formData.append("contract_file", $("#contract_file")[0].files[0]);

            if (id) formData.append("id", id);

            $.ajax({
                url: "save_deal.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                dataType: "json",
                success: function(response) {
                    alert(response.message);
                    if (response.status === "success") {
                        $("#leadModal").modal("hide");
                        loadLeads();
                    }
                },
                error: function(xhr) {
                    alert(xhr.responseText || "Error saving deal");
                }
            });
        });
    });
})();
</script>


  </body>
</html>
