<?php
session_start();
include 'connection.php';

header('Content-Type: application/json');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {

    if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
        throw new Exception("Invalid lead ID");
    }

    $lead_id  = (int)$_POST['id'];
    $agent_id = $_SESSION['user_id'] ?? 1;

    $stmt = $con->prepare(
        "DELETE FROM sales_calls WHERE id=? AND agent_id=?"
    );
    $stmt->bind_param("ii", $lead_id, $agent_id);
    $stmt->execute();

    if ($stmt->affected_rows === 0) {
        throw new Exception("Lead not found or permission denied");
    }

    $stmt->close();

    echo json_encode([
        "status" => "success",
        "message" => "Lead deleted successfully"
    ]);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
