<?php
session_start();
include 'connection.php';

$id = $_POST['id'] ?? null;

if (!$id) {
    echo json_encode(["status"=>"error","message"=>"Invalid ID"]);
    exit;
}

// Get files
$stmt = $con->prepare("SELECT proposal_file, contract_file FROM sales_calls WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($proposal, $contract);
$stmt->fetch();
$stmt->close();

// Delete row
$stmt = $con->prepare("DELETE FROM sales_calls WHERE id=?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    // Delete files if exist
    if ($proposal && file_exists($proposal)) @unlink($proposal);
    if ($contract && file_exists($contract)) @unlink($contract);

    echo json_encode(["status"=>"success","message"=>"Deal deleted successfully"]);
} else {
    echo json_encode(["status"=>"error","message"=>"Failed to delete deal"]);
}
?>
