<?php
session_start();

$isLoggedIn = isset($_SESSION['user_id']);

$userName  = $_SESSION['user_name'] ?? '';
$userEmail = $_SESSION['user_email'] ?? '';
$userRole  = $_SESSION['role'] ?? '';
?>
<!DOCTYPE html>
<html class="no-js" lang="en" dir="ltr">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, shrink-to-fit=no"
    />
    <title>:: My-Task:: Deals</title>
    <link rel="icon" href="favicon.ico" type="image/x-icon" />
    <!-- Favicon-->
    <link
      rel="stylesheet"
      href="assets/plugin/datatables/responsive.dataTables.min.css"
    />
    <link
      rel="stylesheet"
      href="assets/plugin/datatables/dataTables.bootstrap5.min.css"
    />

    <!-- project css file  -->
    <link rel="stylesheet" href="assets/css/my-task.style.min.css" />
    <style>
      /* Compact form styling for Lead Contact and Company Details */
      .add-client h4 {
        font-size: 16px;
        font-weight: 600;
        padding: 12px 20px;
        margin-bottom: 0;
      }
      .add-client .f-14,
      .add-client label,
      .add-client .form-check-label {
        font-size: 13px !important;
        color: #495057;
      }
      .add-client .form-group {
        margin-bottom: 10px;
      }
      .add-client .form-control {
        height: 38px;
        font-size: 13px;
        padding: 6px 10px;
        border-radius: 6px;
      }
      .add-client .input-group-text {
        font-size: 13px;
      }
      .add-client .form-check-input {
        width: 18px;
        height: 18px;
      }
      .add-client .row.p-20 {
        padding: 12px;
      }
      .add-client .border-top-grey {
        border-top: 1px solid #e9ecef;
      }

      /* View modal compact rows */
      #viewLeadBody .text-muted {
        font-size: 13px;
      }
      #viewLeadBody .fw-bold {
        font-size: 14px;
      }
      #viewLeadBody h6 {
        font-size: 15px;
        margin-top: 6px;
      }

      /* Make modal slightly tighter */
      .modal-lg .modal-body {
        padding: 16px 20px;
      }

      /* Responsive tweaks */
      @media (max-width: 576px) {
        .add-client .form-control {
          height: 42px;
        }
        .add-client h4 {
          font-size: 15px;
        }
      }
    </style>
  </head>
  <body data-mytask="theme-indigo">
    <div id="mytask-layout">
      <!-- sidebar -->
      <div class="sidebar px-4 py-4 py-md-5 me-0">
        <div class="d-flex flex-column h-100">
          <a href="index-2.html" class="mb-0 brand-icon">
            <span class="logo-icon">
              <svg
                width="35"
                height="35"
                fill="currentColor"
                class="bi bi-clipboard-check"
                viewBox="0 0 16 16"
              >
                <path
                  fill-rule="evenodd"
                  d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z"
                />
                <path
                  d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"
                />
                <path
                  d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"
                />
              </svg>
            </span>
            <span class="logo-text">My-Task</span>
          </a>
          <!-- Menu: main ul -->
          <ul class="menu-list flex-grow-1 mt-3">
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#dashboard-Components"
                href="#"
              >
                <i class="icofont-home fs-5"></i> <span>Dashboard</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="dashboard-Components">
                <li>
                  <a class="ms-link" href="index-2.html">
                    <span>Hr Dashboard</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="project-dashboard.html">
                    <span>Project Dashboard</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#project-Components"
                href="#"
              >
                <i class="icofont-briefcase"></i><span>Projects</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="project-Components">
                <li>
                  <a class="ms-link" href="projects.html"
                    ><span>Projects</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="task.html"><span>Tasks</span></a>
                </li>
                <li>
                  <a class="ms-link" href="timesheet.html"
                    ><span>Timesheet</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="team-leader.html"
                    ><span>Leaders</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link active"
                data-bs-toggle="collapse"
                data-bs-target="#leads-Components"
                href="#"
              >
                <i class="icofont-users"></i><span>Leads</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse show" id="leads-Components">
                <li>
                  <a class="ms-link" href="deals.php"
                    ><span>Sales Report</span></a
                  >
                </li>
                <li>
                  <a class="ms-link active" href="lead-contact.php"
                    ><span>Client Data</span></a
                  >
                </li>
              </ul>
            </li>

            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#tikit-Components"
                href="#"
                ><i class="icofont-ticket"></i> <span>Tickets</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="tikit-Components">
                <li>
                  <a class="ms-link" href="tickets.html">
                    <span>Tickets View</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="ticket-detail.html">
                    <span>Ticket Detail</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#client-Components"
                href="#"
                ><i class="icofont-user-male"></i> <span>Our Clients</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="client-Components">
                <li>
                  <a class="ms-link" href="ourclients.html">
                    <span>Clients</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="profile.html">
                    <span>Client Profile</span></a
                  >
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#emp-Components"
                href="#"
                ><i class="icofont-users-alt-5"></i> <span>Employees</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="emp-Components">
                <li>
                  <a class="ms-link" href="members.html">
                    <span>Members</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="employee-profile.html">
                    <span>Members Profile</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="holidays.html">
                    <span>Holidays</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="attendance-employees.html">
                    <span>Attendance Employees</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="attendance.html">
                    <span>Attendance</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="leave-request.html">
                    <span>Leave Request</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="department.html">
                    <span>Department</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="loan.html"> <span>Loan</span></a>
                </li>
              </ul>
            </li>

            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#menu-Componentsone"
                href="#"
                ><i class="icofont-ui-calculator"></i> <span>Accounts</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="menu-Componentsone">
                <li>
                  <a class="ms-link" href="invoices.html"
                    ><span>Invoices</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="payments.html"
                    ><span>Payments</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="expenses.html"
                    ><span>Expenses</span>
                  </a>
                </li>
                <li>
                  <a class="ms-link" href="create-invoice.html"
                    ><span>Create Invoice</span>
                  </a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#payroll-Components"
                href="#"
                ><i class="icofont-users-alt-5"></i> <span>Payroll</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="payroll-Components">
                <li>
                  <a class="ms-link" href="salaryslip.html"
                    ><span>Employee Salary</span>
                  </a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#app-Components"
                href="#"
              >
                <i class="icofont-contrast"></i> <span>App</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="app-Components">
                <li>
                  <a class="ms-link" href="calendar.html">
                    <span>Calander</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="chat.html"><span>Chat App</span></a>
                </li>
              </ul>
            </li>
            <li class="collapsed">
              <a
                class="m-link"
                data-bs-toggle="collapse"
                data-bs-target="#extra-Components"
                href="#"
              >
                <i class="icofont-code-alt"></i> <span>Other Pages</span>
                <span
                  class="arrow icofont-dotted-down ms-auto text-end fs-5"
                ></span
              ></a>
              <!-- Menu: Sub menu ul -->
              <ul class="sub-menu collapse" id="extra-Components">
                <li>
                  <a class="ms-link" href="charts.html">
                    <span>Apex Charts</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="forms.html"
                    ><span>Forms Example</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="table.html">
                    <span>Table Example</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="review.html"
                    ><span>Reviews Page</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="icon.html"><span>Icons</span></a>
                </li>
                <li>
                  <a class="ms-link" href="contact.html"
                    ><span>Contact</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="widgets.html"
                    ><span>Widgets</span></a
                  >
                </li>
                <li>
                  <a class="ms-link" href="todo-list.html"
                    ><span>Todo-List</span></a
                  >
                </li>
              </ul>
            </li>
            <li>
              <a class="m-link" href="ui-elements/ui-alerts.html"
                ><i class="icofont-paint"></i> <span>UI Components</span></a
              >
            </li>
          </ul>

          <!-- Menu: menu collepce btn -->
          <button
            type="button"
            class="btn btn-link sidebar-mini-btn text-light"
          >
            <span class="ms-2"><i class="icofont-bubble-right"></i></span>
          </button>
        </div>
      </div>

      <!-- main body area -->
      <div class="main px-lg-4 px-md-4">
        <!-- Body: Header -->        <div class="header">
          <nav class="navbar py-4">
            <div class="container-xxl">
              <!-- header rightbar icon -->
              <div
                class="h-right d-flex align-items-center mr-5 mr-lg-0 order-1"
              >
                <div class="d-flex">
                  <a
                    class="nav-link text-primary collapsed"
                    href="help.html"
                    title="Get Help"
                  >
                    <i class="icofont-info-square fs-5"></i>
                  </a>
                  <div class="avatar-list avatar-list-stacked px-3">
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar2.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar1.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar3.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar4.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar7.jpg"
                      alt=""
                    />
                    <img
                      class="avatar rounded-circle"
                      src="assets/images/xs/avatar8.jpg"
                      alt=""
                    />
                    <span
                      class="avatar rounded-circle text-center pointer"
                      data-bs-toggle="modal"
                      data-bs-target="#addUser"
                      ><i class="icofont-ui-add"></i
                    ></span>
                  </div>
                </div>
                <div class="dropdown notifications">
                  <a
                    class="nav-link dropdown-toggle pulse"
                    href="#"
                    role="button"
                    data-bs-toggle="dropdown"
                  >
                    <i class="icofont-alarm fs-5"></i>
                    <span class="pulse-ring"></span>
                  </a>
                  <div
                    id="NotificationsDiv"
                    class="dropdown-menu rounded-lg shadow border-0 dropdown-animation dropdown-menu-sm-end p-0 m-0"
                  >
                    <div class="card border-0 w380">
                      <div class="card-header border-0 p-3">
                        <h5
                          class="mb-0 font-weight-light d-flex justify-content-between"
                        >
                          <span>Notifications</span>
                          <span class="badge text-white">11</span>
                        </h5>
                      </div>
                      <div class="tab-content card-body">
                        <div class="tab-pane fade show active">
                          <ul class="list-unstyled list mb-0">
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle"
                                  src="assets/images/xs/avatar1.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Shalini</span
                                    >
                                    <small>2MIN</small>
                                  </p>
                                  <span class=""
                                    >Added 2021-02-19 my-Task ui/ux Design
                                    <span class="badge bg-success"
                                      >Review</span
                                    ></span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <div class="avatar rounded-circle no-thumbnail">
                                  DF
                                </div>
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Diane Fisher</span
                                    >
                                    <small>13MIN</small>
                                  </p>
                                  <span class=""
                                    >Task added Get Started with Fast Cad
                                    project</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar3.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Andrea Gill</span
                                    >
                                    <small>1HR</small>
                                  </p>
                                  <span class=""
                                    >Quality Assurance Task Completed</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar5.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Diane Fisher</span
                                    >
                                    <small>13MIN</small>
                                  </p>
                                  <span class=""
                                    >Add New Project for App Developemnt</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2 mb-1 border-bottom">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar6.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Andrea Gill</span
                                    >
                                    <small>1HR</small>
                                  </p>
                                  <span class=""
                                    >Add Timesheet For Rhinestone project</span
                                  >
                                </div>
                              </a>
                            </li>
                            <li class="py-2">
                              <a href="javascript:void(0);" class="d-flex">
                                <img
                                  class="avatar rounded-circle sm"
                                  src="assets/images/xs/avatar7.jpg"
                                  alt=""
                                />
                                <div class="flex-fill ms-2">
                                  <p
                                    class="d-flex justify-content-between mb-0"
                                  >
                                    <span class="font-weight-bold"
                                      >Zoe Wright</span
                                    >
                                    <small class="">1DAY</small>
                                  </p>
                                  <span class="">Add Calander Event</span>
                                </div>
                              </a>
                            </li>
                          </ul>
                        </div>
                      </div>
                      <a class="card-footer text-center border-top-0" href="#">
                        View all notifications</a
                      >
                    </div>
                  </div>
                </div>
                            <div class="dropdown user-profile ml-2 ml-sm-3 d-flex align-items-center">

    <?php if ($isLoggedIn): ?>
        <!-- User Info -->
        <div class="u-info me-2">
            <p class="mb-0 text-end line-height-sm">
                <span class="font-weight-bold">
                    <?php echo htmlspecialchars($userName); ?>

                </span>
            </p>
            <small><?php echo htmlspecialchars($userRole); ?> Profile</small>
        </div>
    <?php endif; ?>

    <a class="nav-link dropdown-toggle pulse p-0" href="#" role="button"
       data-bs-toggle="dropdown" data-bs-display="static">
        <img class="avatar lg rounded-circle img-thumbnail"
             src="assets/images/profile_av.png" alt="profile">
    </a>

    <div class="dropdown-menu rounded-lg shadow border-0 dropdown-animation dropdown-menu-end p-0 m-0">
        <div class="card border-0 w280">

            <?php if ($isLoggedIn): ?>
                <!-- Logged-in User Details -->
                <div class="card-body pb-0">
                    <div class="d-flex py-1">
                        <img class="avatar rounded-circle"
                             src="assets/images/profile_av.png" alt="profile">

                        <div class="flex-fill ms-3">
                            <p class="mb-0">
                                <span class="font-weight-bold">
                                   <?php echo htmlspecialchars($userName); ?>

                                </span>
                            </p>
                            <small>
                                <?php echo htmlspecialchars($userEmail); ?>

                            </small>
                        </div>
                    </div>
                    <hr class="dropdown-divider border-dark">
                </div>

                <!-- Logged-in Menu -->
                <div class="list-group m-2">
                   <!--  <a href="task.html" class="list-group-item list-group-item-action border-0">
                        <i class="icofont-tasks fs-5 me-3"></i>My Task
                    </a>

                    <a href="members.html" class="list-group-item list-group-item-action border-0">
                        <i class="icofont-ui-user-group fs-6 me-3"></i>Members
                    </a> -->

                    <a href="logout.php" class="list-group-item list-group-item-action border-0 text-danger">
                        <i class="icofont-logout fs-6 me-3"></i>Logout
                    </a>
                </div>

            <?php else: ?>
                <!-- Guest Menu -->
                <div class="list-group m-2">
                    <a href="ui-elements/auth-signin.php"
                       class="list-group-item list-group-item-action border-0">
                        <i class="icofont-login fs-6 me-3"></i>Login
                    </a>

                    <a href="ui-elements/auth-signup.php"
                       class="list-group-item list-group-item-action border-0">
                        <i class="icofont-contact-add fs-5 me-3"></i>Sign Up
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>

                <div class="px-md-1">
                  <a
                    href="#offcanvas_setting"
                    data-bs-toggle="offcanvas"
                    aria-expanded="false"
                    title="template setting"
                  >
                    <svg
                      class="svg-stroke"
                      xmlns="http://www.w3.org/2000/svg"
                      width="22"
                      height="22"
                      viewBox="0 0 24 24"
                      stroke="currentColor"
                      fill="none"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    >
                      <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                      <path
                        d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z"
                      ></path>
                      <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                    </svg>
                  </a>
                </div>
              </div>

              <!-- menu toggler -->
              <button
                class="navbar-toggler p-0 border-0 menu-toggle order-3"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#mainHeader"
              >
                <span class="fa fa-bars"></span>
              </button>

              <!-- main menu Search-->
              <div
                class="order-0 col-lg-4 col-md-4 col-sm-12 col-12 mb-3 mb-md-0"
              >
                <div class="input-group flex-nowrap input-group-lg">
                  <button
                    type="button"
                    class="input-group-text"
                    id="addon-wrapping"
                  >
                    <i class="fa fa-search"></i>
                  </button>
                  <input
                    type="search"
                    class="form-control"
                    placeholder="Search"
                    aria-label="search"
                    aria-describedby="addon-wrapping"
                  />
                  <button
                    type="button"
                    class="input-group-text add-member-top"
                    id="addon-wrappingone"
                    data-bs-toggle="modal"
                    data-bs-target="#addUser"
                  >
                    <i class="fa fa-plus"></i>
                  </button>
                </div>
              </div>
            </div>
          </nav>
        </div>

        <!-- Body: Body -->
      <!-- Sales Report Page -->
<div class="body d-flex py-lg-3 py-md-2">
  <div class="container-xxl">
    <div class="row align-items-center">
      <div class="border-0 mb-4">
        <div class="card-header py-3 no-bg bg-transparent d-flex align-items-center px-0 justify-content-between border-bottom flex-wrap">
          <h3 class="fw-bold mb-0">Sales Report</h3>
          <div class="col-auto d-flex w-sm-100">
            <button id="addDealBtn" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#leadModal">
              <i class="icofont-plus-circle me-2"></i>Add New Deal
            </button>
          </div>
        </div>
      </div>
    </div>

    <!-- Table -->
    <div class="row clearfix g-3">
      <div class="col-sm-12">
        <div class="card mb-3">
          <div class="card-body">
            <div class="table-responsive">
              <table id="leadcontact" class="table table-hover align-middle">
                <thead>
                  <tr>
                    <th>Client Name</th>
                    <th>Client Company Name</th>
                    <th>Mobile</th>
                    <th>Alt Mobile</th>
                    <th>Email</th>
                    <th>Address</th>
                    <th>Total Price</th>
                    <th>Initial Pay</th>
                    <th>Pending Pay</th>
                    <th>Term Plan</th>
                    <th>Project start date</th>
                    <th>Project end date</th>
                    <th>Stage</th>
                    <th>Assigned to</th>
                    <th>Renewal Date</th>
                    <th>Renewal Cost</th>
                    <th>Domain</th>
                    <th>Hosting</th>
                    <th>Service</th>
                    <th>Contract File</th>
                    <th>Business Type</th>
                    <th>Duration</th>
                    <th class="text-end">Action</th>
                    <th>Agent</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Add / Edit Lead Modal -->
    <div class="modal fade" id="leadModal" tabindex="-1" aria-labelledby="leadModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title fw-bold" id="leadModalLabel">Add / Edit Lead Contact</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="add-client bg-white rounded">
              <h4 class="mb-0 p-20 f-21 font-weight-normal border-bottom-grey">Lead Contact Detail</h4>
              <div class="row p-20" id="lead_form">
                <!-- Client Name -->
                <div class="col-lg-4 col-md-6">
                  <label class="f-14 text-dark-grey mb-12">Client Name *</label>
                  <input type="text" id="client_name" class="form-control">
                </div>

                <!-- Mobile -->
                <div class="col-lg-4 col-md-6">
                  <label class="f-14 text-dark-grey mb-12">Mobile *</label>
                  <input type="tel" id="mobile" class="form-control" maxlength="10">
                </div>

                <!-- Email -->
                <div class="col-lg-4 col-md-6">
                  <label>Client Email</label>
                  <input type="email" id="client_email" class="form-control">
                </div>

                <!-- Alt Mobile -->
                <div class="col-lg-4 col-md-6">
                  <label>Alternative Mobile</label>
                  <input type="tel" id="alt_mobile" class="form-control">
                </div>

                <!-- Service -->
                <div class="col-lg-4 col-md-6">
                  <label>Service</label>
                  <select id="service" class="form-control">
                    <option value="static website development">Static Website Development</option>
                    <option value="dynamic website development">Dynamic Website Development</option>
                    <option value="ecommerce website development">Ecommerce Website Development</option>
                    <option value="seo">SEO</option>
                    <option value="social media">Social Media</option>
                    <option value="video editing">Video Editing</option>
                    <option value="gmb only">GMB only</option>
                    <option value="poster design">Poster Design</option>
                    <option value="website + seo">Website + SEO</option>
                    <option value="social media + seo">Social Media + SEO</option>
                    <option value="social media + seo + gmb">Social Media + SEO + GMB</option>
                  </select>
                </div>

                <!-- Company Name -->
                <div class="col-lg-4 col-md-6">
                  <label>Company Name *</label>
                  <input type="text" id="company_name" class="form-control">
                </div>

                <!-- Domain -->
                <div class="col-lg-4 col-md-6">
                  <label>Domain</label>
                  <select id="domain" class="form-control">
                    <option value="user">User</option>
                    <option value="company">Company</option>
                  </select>
                </div>

                <!-- Hosting -->
                <div class="col-lg-4 col-md-6">
                  <label>Hosting</label>
                  <select id="hosting" class="form-control">
                    <option value="user">User</option>
                    <option value="company">Company</option>
                  </select>
                </div>

                <!-- Total Price -->
                <div class="col-lg-4 col-md-6">
                  <label>Total Price *</label>
                  <input type="number" id="total_price" class="form-control" value="0">
                </div>

                <!-- Initial Payment -->
                <div class="col-lg-4 col-md-6">
                  <label>Initial Payment</label>
                  <input type="number" id="initial_pay" class="form-control" value="0">
                </div>

                <!-- Pending Payment -->
                <div class="col-lg-4 col-md-6">
                  <label>Pending Payment</label>
                  <input type="number" id="pending_pay" class="form-control" value="0">
                </div>

                <!-- Term Plan -->
                <div class="col-lg-4 col-md-6">
                  <label>Term Plan</label>
                  <select id="term_plan" class="form-control">
                    <option value="Fixed">Fixed</option>
                    <option value="Flexible">Flexible</option>
                  </select>
                </div>

                <!-- Project Start Date -->
                <div class="col-lg-4 col-md-6">
                  <label>Project Start Date</label>
                  <input type="date" id="project_start_date" class="form-control">
                </div>

                <!-- Project End Date -->
                <div class="col-lg-4 col-md-6">
                  <label>Project End Date</label>
                  <input type="date" id="project_end_date" class="form-control">
                </div>

                <!-- Assigned To -->
                <div class="col-lg-4 col-md-6">
                  <label>Assigned To</label>
                  <select id="assigned_to" class="form-control">
                    <option value="Amit">Amit</option>
                    <option value="Ibrahim">Ibrahim</option>
                    <option value="Nitish">Nitish</option>
                    <option value="Ananya">Ananya</option>
                  </select>
                </div>

                <!-- Stage -->
                <div class="col-lg-4 col-md-6">
                  <label>Stage</label>
                  <select id="stage" class="form-control">
                    <option value="Generated">Generated</option>
                    <option value="In Progress">In Progress</option>
                    <option value="Completed">Completed</option>
                  </select>
                </div>

                <!-- Business Type -->
                <div class="col-lg-4 col-md-6">
                  <label>Business Type</label>
                  <input type="text" id="business_type" class="form-control">
                </div>

                <!-- Address -->
                <div class="col-lg-12 col-md-12">
                  <label>Address</label>
                  <textarea id="address" class="form-control" rows="2"></textarea>
                </div>

                <!-- Renewal Date -->
                <div class="col-lg-4 col-md-6">
                  <label>Renewal Date</label>
                  <input type="date" id="renewal_date" class="form-control">
                </div>

                <!-- Renewal Cost -->
                <div class="col-lg-4 col-md-6">
                  <label>Renewal Cost</label>
                  <input type="number" id="renewal_cost" class="form-control" value="0">
                </div>

                <!-- Contract File -->
                <div class="col-lg-4 col-md-6">
                  <label>Contract (PDF)</label>
                  <input type="file" id="contract_file" class="form-control">
                </div>

                <!-- Duration -->
                <div class="col-lg-4 col-md-6">
                  <label>Duration</label>
                  <select id="duration" class="form-control">
                    <option value="1month">1 Month</option>
                    <option value="6month">6 Months</option>
                    <option value="1year">1 Year</option>
                  </select>
                </div>

                <!-- Deal Agent -->
               <div class="col-lg-4 col-md-6">
    <label>Deal Agent</label>
    <input type="text" class="form-control" value="<?php echo htmlspecialchars($_SESSION['user_name']); ?>" readonly>
</div>



              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-primary" id="save-lead-form">Save</button>
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          </div>
        </div>
      </div>
    </div>

    <!-- View Lead Modal -->
    <div class="modal fade" id="viewLeadModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Lead Details</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body" id="viewLeadBody"></div>
        </div>
      </div>
    </div>

  </div>
</div>

        <!-- Modal Members-->
        <div
          class="modal fade"
          id="addUser"
          tabindex="-1"
          aria-labelledby="addUserLabel"
          aria-hidden="true"
        >
          <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title fw-bold" id="addUserLabel">
                  Employee Invitation
                </h5>
                <button
                  type="button"
                  class="btn-close"
                  data-bs-dismiss="modal"
                  aria-label="Close"
                ></button>
              </div>
              <div class="modal-body">
                <div class="inviteby_email">
                  <div class="input-group mb-3">
                    <input
                      type="email"
                      class="form-control"
                      placeholder="Email address"
                      id="exampleInputEmail1"
                      aria-describedby="exampleInputEmail1"
                    />
                    <button
                      class="btn btn-dark"
                      type="button"
                      id="button-addon2"
                    >
                      Sent
                    </button>
                  </div>
                </div>
                <div class="members_list">
                  <h6 class="fw-bold">Employee</h6>
                  <ul
                    class="list-unstyled list-group list-group-custom list-group-flush mb-0"
                  >
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar2.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">Rachel Carr(you)</h6>
                          <span class="text-muted">rachel.carr@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <span class="members-role">Admin</span>
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              <i class="icofont-ui-settings fs-6"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-ui-password fs-6 me-2"></i
                                  >ResetPassword</a
                                >
                              </li>
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-chart-line fs-6 me-2"></i
                                  >ActivityReport</a
                                >
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar3.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">
                            Lucas Baker<a href="#" class="link-secondary ms-2"
                              >(Resend invitation)</a
                            >
                          </h6>
                          <span class="text-muted">lucas.baker@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              Members
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="icofont-check-circled"></i>

                                  <span>All operations permission</span>
                                </a>
                              </li>
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="fs-6 p-2 me-1"></i>
                                  <span>Only Invite & manage team</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              <i class="icofont-ui-settings fs-6"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#"
                                  ><i class="icofont-delete-alt fs-6 me-2"></i
                                  >Delete Member</a
                                >
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                    <li class="list-group-item py-3 text-center text-md-start">
                      <div
                        class="d-flex align-items-center flex-column flex-sm-column flex-md-column flex-lg-row"
                      >
                        <div class="no-thumbnail mb-2 mb-md-0">
                          <img
                            class="avatar lg rounded-circle"
                            src="assets/images/xs/avatar8.jpg"
                            alt=""
                          />
                        </div>
                        <div class="flex-fill ms-3 text-truncate">
                          <h6 class="mb-0 fw-bold">Una Coleman</h6>
                          <span class="text-muted">una.coleman@gmail.com</span>
                        </div>
                        <div class="members-action">
                          <div class="btn-group">
                            <button
                              type="button"
                              class="btn bg-transparent dropdown-toggle"
                              data-bs-toggle="dropdown"
                              aria-expanded="false"
                            >
                              Members
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="icofont-check-circled"></i>

                                  <span>All operations permission</span>
                                </a>
                              </li>
                              <li>
                                <a class="dropdown-item" href="#">
                                  <i class="fs-6 p-2 me-1"></i>
                                  <span>Only Invite & manage team</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                          <div class="btn-group">
                            <div class="btn-group">
                              <button
                                type="button"
                                class="btn bg-transparent dropdown-toggle"
                                data-bs-toggle="dropdown"
                                aria-expanded="false"
                              >
                                <i class="icofont-ui-settings fs-6"></i>
                              </button>
                              <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i
                                      class="icofont-ui-password fs-6 me-2"
                                    ></i
                                    >ResetPassword</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i class="icofont-chart-line fs-6 me-2"></i
                                    >ActivityReport</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i class="icofont-delete-alt fs-6 me-2"></i
                                    >Suspend member</a
                                  >
                                </li>
                                <li>
                                  <a class="dropdown-item" href="#"
                                    ><i
                                      class="icofont-not-allowed fs-6 me-2"
                                    ></i
                                    >Delete Member</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- start: template setting, and more. -->
      <div
        class="offcanvas offcanvas-end"
        tabindex="-1"
        id="offcanvas_setting"
        aria-labelledby="offcanvas_setting"
      >
        <div class="offcanvas-header">
          <h5 class="offcanvas-title">Template Setting</h5>
          <button
            type="button"
            class="btn-close"
            data-bs-dismiss="offcanvas"
            aria-label="Close"
          ></button>
        </div>
        <div class="offcanvas-body d-flex flex-column">
          <div class="mb-4">
            <h6>Set Theme Color</h6>
            <ul class="choose-skin list-unstyled mb-0">
              <li data-theme="ValenciaRed">
                <div style="--mytask-theme-color: #d63b38"></div>
              </li>
              <li data-theme="SunOrange">
                <div style="--mytask-theme-color: #f7a614"></div>
              </li>
              <li data-theme="AppleGreen">
                <div style="--mytask-theme-color: #5bc43a"></div>
              </li>
              <li data-theme="CeruleanBlue">
                <div style="--mytask-theme-color: #00b8d6"></div>
              </li>
              <li data-theme="Mariner">
                <div style="--mytask-theme-color: #0066fe"></div>
              </li>
              <li data-theme="PurpleHeart" class="active">
                <div style="--mytask-theme-color: #6238b3"></div>
              </li>
              <li data-theme="FrenchRose">
                <div style="--mytask-theme-color: #eb5393"></div>
              </li>
            </ul>
          </div>
          <div class="mb-4 flex-grow-1">
            <h6>Set Theme Light/Dark/RTL</h6>
            <!-- Theme: Switch Theme -->
            <ul class="list-unstyled mb-0">
              <li>
                <div class="form-check form-switch theme-switch">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="theme-switch"
                  />
                  <label class="form-check-label mx-2" for="theme-switch"
                    >Enable Dark Mode!</label
                  >
                </div>
              </li>
              <li>
                <div class="form-check form-switch theme-rtl">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="theme-rtl"
                  />
                  <label class="form-check-label mx-2" for="theme-rtl"
                    >Enable RTL Mode!</label
                  >
                </div>
              </li>
              <li>
                <div class="form-check form-switch monochrome-toggle">
                  <input
                    class="form-check-input fs-6"
                    type="checkbox"
                    role="switch"
                    id="monochrome"
                  />
                  <label class="form-check-label mx-2" for="monochrome"
                    >Monochrome Mode</label
                  >
                </div>
              </li>
            </ul>
          </div>
          <div class="d-flex">
            <a
              href="https://themeforest.net/item/mytask-hr-project-management-admin-template/31974551"
              class="btn w-100 me-1 py-2 btn-primary"
              >Buy Now</a
            >
            <a
              href="https://themeforest.net/user/pixelwibes/portfolio"
              class="btn w-100 ms-1 py-2 btn-dark"
              >View Portfolio</a
            >
          </div>
        </div>
      </div>
    </div>

    <!-- Jquery Core Js -->
    <script src="assets/bundles/libscripts.bundle.js"></script>

    <!-- Plugin Js-->
    <script src="assets/bundles/dataTables.bundle.js"></script>

    <!-- Jquery Page Js -->
    <script src="../js/template.js"></script>

<!-- <script>
(function(){
  var STORAGE_KEY = 'leads_demo_v3';
  var leads = [];
  var dt = null;

  function load(){
    var raw = localStorage.getItem(STORAGE_KEY);
    if(raw){
      leads = JSON.parse(raw);
    } else {
      leads = [{
        id:1,
        dealName:'Website Redesign',
        leadName:'Ava Thompson',
        mobile:'9876543210',
        call_date:'2026-01-10',
        value:250000,
        stage:'Qualified',
        duration:'1year',
        service:'Digital Marketing',
        contract:'Not Sent',
        agent:'16',
        agent_text:'Shana Jakubowski'
      }];
      save();
    }
  }

  function save(){
    localStorage.setItem(STORAGE_KEY, JSON.stringify(leads));
  }

  function stageBadge(s){
    return '<span class="badge bg-primary">'+s+'</span>';
  }

  function yesNoBadge(v){
    return '<span class="badge bg-secondary">'+v+'</span>';
  }

  function actionDropdown(id){
    return `
      <div class="dropdown">
        <button class="btn btn-sm btn-light dropdown-toggle" data-bs-toggle="dropdown">
          Action
        </button>
        <ul class="dropdown-menu">
          <li><a class="dropdown-item action-item" data-action="view" data-id="${id}">View</a></li>
          <li><a class="dropdown-item action-item" data-action="edit" data-id="${id}">Edit</a></li>
          <li><a class="dropdown-item text-danger action-item" data-action="delete" data-id="${id}">Delete</a></li>
        </ul>
      </div>`;
  }

function render() {
  var rows = leads.map(l => [
    /* 1  */ l.leadName || '--',
    /* 2  */ l.dealName || '--',
    /* 3  */ l.mobile || '--',
    /* 4  */ l.alt_mobile || '--',
    /* 5  */ l.client_email || '--',

    /* 6  */ '₹' + Number(l.value || 0).toLocaleString('en-IN'),
    /* 7  */ '₹' + Number(l.initial_payment || 0).toLocaleString('en-IN'),
    /* 8  */ '₹' + Number(l.pending_payment || 0).toLocaleString('en-IN'),

    /* 9  */ l.term_plan || '--',
    /* 10 */ l.project_start_date || '--',
    /* 11 */ l.project_end_date || '--',
    /* 12 */ l.assigned_to || '--',

    /* 13 */ l.renewal_date || '--',
    /* 14 */ '₹' + Number(l.renewal_cost || 0).toLocaleString('en-IN'),

    /* 15 */ l.domain || '--',
    /* 16 */ l.hosting || '--',
    /* 17 */ l.service || '--',

    /* 18 */ l.contract_file
      ? `<span class="badge bg-success">${l.contract_file}</span>`
      : `<span class="badge bg-secondary">Not Uploaded</span>`,

    /* 19 */ stageBadge(l.stage || 'Generated'),
    /* 20 */ yesNoBadge(l.duration || '1month'),

    /* 21 */ actionDropdown(l.id),
    /* 22 */ l.agent_text || '--'
  ]);

  if (dt) {
    dt.clear().rows.add(rows).draw(false);
  } else {
    dt = $('#leadcontact').DataTable({
      data: rows,
      responsive: true,
      ordering: false,
      pageLength: 10,
      columnDefs: [
        { targets: 20, orderable: false, className: 'text-end' },
        { targets: 21, className: 'fw-semibold' }
      ]
    });
  }
}



  function find(id){
    return leads.find(x => x.id == id);
  }

function openEdit(id){
  var l = id ? find(id) : {};

  $('#leadModal').data('editingId', id || null);

  $('#client_name').val(l.leadName || '');
  $('#name').val(l.dealName || '');
  $('#mobile').val(l.mobile || '');
  $('#alt_mobile').val(l.alt_mobile || '');
  $('#client_email').val(l.client_email || '');

  $('#value').val(l.value || 0);
  $('#initial_payment').val(l.initial_payment || 0);
  $('#pending_payment').val(l.pending_payment || 0);

  $('#duration').val(l.duration || '1month');
  $('#service').val(l.service || 'static website development');

  $('#domain').val(l.domain || 'user');
  $('#hosting').val(l.hosting || 'user');

  $('#renewal_date').val(l.renewal_date || '');
  $('#renewal_cost').val(l.renewal_cost || 0);

  $('#call_date').val(l.project_start_date || '');

  $('#deal_agent_id').val(l.agent || '');

  // file input cannot be prefilled
  $('#contract_file').val('');

  $('#leadModal').modal('show');
}


function showView(id){
  var l = find(id);

  $('#viewLeadBody').html(`
    <p><b>Client Name:</b> ${l.leadName || '--'}</p>
    <p><b>Client Company Name:</b> ${l.dealName || '--'}</p>
    <p><b>Mobile:</b> ${l.mobile || '--'}</p>
    <p><b>Alt Mobile:</b> ${l.alt_mobile || '--'}</p>
    <p><b>Email:</b> ${l.client_email || '--'}</p>
    <p><b>Total Price:</b> ₹${Number(l.value || 0).toLocaleString('en-IN')}</p>
    <p><b>Initial Pay:</b> ₹${Number(l.initial_payment || 0).toLocaleString('en-IN')}</p>
    <p><b>Pending Pay:</b> ₹${Number(l.pending_payment || 0).toLocaleString('en-IN')}</p>
    <p><b>Term Plan:</b> ${l.term_plan || '--'}</p>
    <p><b>Project Start Date:</b> ${l.project_start_date || '--'}</p>
    <p><b>Project End Date:</b> ${l.project_end_date || '--'}</p>
    <p><b>Assigned To:</b> ${l.assigned_to || '--'}</p>
    <p><b>Renewal Date:</b> ${l.renewal_date || '--'}</p>
    <p><b>Renewal Cost:</b> ₹${Number(l.renewal_cost || 0).toLocaleString('en-IN')}</p>
    <p><b>Domain:</b> ${l.domain || '--'}</p>
    <p><b>Hosting:</b> ${l.hosting || '--'}</p>
    <p><b>Service:</b> ${l.service || '--'}</p>
    <p><b>Contract File:</b> ${l.contract_file ? `<a href="uploads/${l.contract_file}" target="_blank">${l.contract_file}</a>` : 'Not Uploaded'}</p>
    <p><b>Stage:</b> ${l.stage || '--'}</p>
    <p><b>Duration:</b> ${l.duration || '--'}</p>
    <p><b>Agent:</b> ${l.agent_text || '--'}</p>
  `);

  $('#viewLeadModal').modal('show');
}



  $(function(){
    load();
    render();

    $(document).on('click','.action-item',function(e){
      e.preventDefault();
      var id = $(this).data('id');
      var act = $(this).data('action');
      if(act === 'edit') openEdit(id);
      if(act === 'view') showView(id);
      if(act === 'delete'){
        leads = leads.filter(x => x.id != id);
        save();
        render();
      }
    });

    $('#addDealBtn').on('click', function () {

  $('#leadModal').removeData('editingId');
  $('#leadModal').find('input[type="text"], input[type="number"], input[type="email"], input[type="tel"], input[type="date"]').val('');
  $('#leadModal').find('select').prop('selectedIndex', 0);


  $('#value').val(0);
  $('#initial_payment').val(0);
  $('#pending_payment').val(0);
  $('#renewal_cost').val(0);
});


   $('#save-lead-form').click(function(){
  var id = $('#leadModal').data('editingId');

  var obj = {
    id: id || Date.now(),

    leadName: $('#client_name').val(),
    dealName: $('#name').val(),
    mobile: $('#mobile').val(),
    alt_mobile: $('#alt_mobile').val(),
    client_email: $('#client_email').val(),

    value: Number($('#value').val() || 0),
    initial_payment: Number($('#initial_payment').val() || 0),
    pending_payment: Number($('#pending_payment').val() || 0),

    term_plan: 'Fixed',
    project_start_date: $('#call_date').val(),
    project_end_date: '',

    assigned_to: $('#deal_agent_id option:selected').text(),

    renewal_date: $('#renewal_date').val(),
    renewal_cost: Number($('#renewal_cost').val() || 0),

    domain: $('#domain').val(),
    hosting: $('#hosting').val(),
    service: $('#service').val(),

    contract_file: $('#contract_file')[0].files[0]?.name || '',

    stage: 'Generated',
    duration: $('#duration').val(),

    agent: $('#deal_agent_id').val(),
    agent_text: $('#deal_agent_id option:selected').text()
  };

  if (id) {
    leads = leads.map(x => x.id == id ? obj : x);
  } else {
    leads.push(obj);
  }

  save();
  render();
  $('#leadModal').modal('hide');
});

  });
})();
</script> -->
<script>
(function(){
  var leads = [];
  var dt = null;

  // Load leads from server
  function loadLeads() {
    $.ajax({
      url: 'get_clients.php',
      method: 'GET',
      dataType: 'json',
      success: function(data){
        leads = data;
        renderTable();
      },
      error: function(err){
        console.error('Failed to load leads:', err);
      }
    });
  }

  // Stage badge
  function stageBadge(stage){
    return '<span class="badge bg-primary">' + (stage || 'Generated') + '</span>';
  }

  // Duration badge
  function durationBadge(duration){
    return '<span class="badge bg-secondary">' + (duration || '1month') + '</span>';
  }

  // Action dropdown
  function actionDropdown(id){
    return `<div class="dropdown">
      <button class="btn btn-sm btn-light dropdown-toggle" data-bs-toggle="dropdown">Action</button>
      <ul class="dropdown-menu">
        <li><a class="dropdown-item action-item" data-action="view" data-id="${id}">View</a></li>
        <li><a class="dropdown-item action-item" data-action="edit" data-id="${id}">Edit</a></li>
        <li><a class="dropdown-item text-danger action-item" data-action="delete" data-id="${id}">Delete</a></li>
      </ul>
    </div>`;
  }

  // Render DataTable
  function renderTable(){
var rows = leads.map(l => [
    l.client_name || '--',
    l.company_name || '--',
    l.mobile || '--',
    l.alt_mobile || '--',
    l.email || '--',
    l.address || '--',
    '₹' + Number(l.total_price||0).toLocaleString('en-IN'),
    '₹' + Number(l.initial_pay||0).toLocaleString('en-IN'),
    '₹' + Number(l.pending_pay||0).toLocaleString('en-IN'),
    l.term_plan || '--',
    l.project_start_date || '--',
    l.project_end_date || '--',
    stageBadge(l.stage),
    l.assigned_to || '--', // keep if needed
    l.renewal_date || '--',
    '₹' + Number(l.renewal_cost||0).toLocaleString('en-IN'),
    l.domain || '--',
    l.hosting || '--',
    l.service || '--',
    l.contract_file 
      ? `<a href="uploads/${l.contract_file}" target="_blank" class="badge bg-success">${l.contract_file}</a>` 
      : `<span class="badge bg-secondary">Not Uploaded</span>`,
    l.business_type || '--',
    durationBadge(l.duration),
    actionDropdown(l.id),
    l.agent_name || '--'  // <-- Add this for column 23
]);

  if(dt){
    dt.clear().rows.add(rows).draw(false);
  } else {
    dt = $('#leadcontact').DataTable({
      data: rows,
      responsive: true,
      ordering: false,
      pageLength: 10,
      columnDefs: [{ targets: 22, orderable: false, className: 'text-end' }]
    });
  }
}


  // Find lead by ID
  function findLead(id){
    return leads.find(x => x.id == id);
  }

  // Open Add/Edit Modal
  function openEditModal(id){
    var lead = id ? findLead(id) : {};
    $('#leadModal').data('editingId', id || null);

    $('#client_name').val(lead.client_name || '');
    $('#company_name').val(lead.company_name || '');
    $('#mobile').val(lead.mobile || '');
    $('#alt_mobile').val(lead.alt_mobile || '');
    $('#client_email').val(lead.email || '');
    $('#total_price').val(lead.total_price || 0);
    $('#initial_pay').val(lead.initial_pay || 0);
    $('#pending_pay').val(lead.pending_pay || 0);
    $('#term_plan').val(lead.term_plan || 'Fixed');
    $('#project_start_date').val(lead.project_start_date || '');
    $('#project_end_date').val(lead.project_end_date || '');
    $('#assigned_to').val(lead.assigned_to || '');
    $('#stage').val(lead.stage || 'Generated');
    $('#duration').val(lead.duration || '1month');
  
    $('#business_type').val(lead.business_type || '');
    $('#address').val(lead.address || '');
    $('#renewal_date').val(lead.renewal_date || '');
    $('#renewal_cost').val(lead.renewal_cost || 0);
    $('#domain').val(lead.domain || 'user');
    $('#hosting').val(lead.hosting || 'user');
    $('#service').val(lead.service || 'static website development');
    $('#contract_file').val('');

    $('#leadModal').modal('show');
  }

  // Show View Modal
  function showViewModal(id){
    var l = findLead(id);
    if(!l) return;

    $('#viewLeadBody').html(`
      <p><b>Client Name:</b> ${l.client_name || '--'}</p>
      <p><b>Company Name:</b> ${l.company_name || '--'}</p>
      <p><b>Mobile:</b> ${l.mobile || '--'}</p>
      <p><b>Alt Mobile:</b> ${l.alt_mobile || '--'}</p>
      <p><b>Email:</b> ${l.email || '--'}</p>
      <p><b>Total Price:</b> ₹${Number(l.total_price||0).toLocaleString('en-IN')}</p>
      <p><b>Initial Pay:</b> ₹${Number(l.initial_pay||0).toLocaleString('en-IN')}</p>
      <p><b>Pending Pay:</b> ₹${Number(l.pending_pay||0).toLocaleString('en-IN')}</p>
      <p><b>Term Plan:</b> ${l.term_plan || '--'}</p>
      <p><b>Project Start Date:</b> ${l.project_start_date || '--'}</p>
      <p><b>Project End Date:</b> ${l.project_end_date || '--'}</p>
      <p><b>Assigned To:</b> ${l.assigned_to || '--'}</p>
      <p><b>Renewal Date:</b> ${l.renewal_date || '--'}</p>
      <p><b>Renewal Cost:</b> ₹${Number(l.renewal_cost||0).toLocaleString('en-IN')}</p>
      <p><b>Domain:</b> ${l.domain || '--'}</p>
      <p><b>Hosting:</b> ${l.hosting || '--'}</p>
      <p><b>Service:</b> ${l.service || '--'}</p>
      <p><b>Contract File:</b> ${l.contract_file ? `<a href="uploads/${l.contract_file}" target="_blank">${l.contract_file}</a>` : 'Not Uploaded'}</p>
      <p><b>Stage:</b> ${l.stage || '--'}</p>
      <p><b>Duration:</b> ${l.duration || '--'}</p>
      <p><b>Agent:</b> ${l.agent_name || '--'}</p>
    `);
    $('#viewLeadModal').modal('show');
  }

  // Delete Lead
  function deleteLead(id){
    if(!confirm('Are you sure you want to delete this lead?')) return;

    $.ajax({
      url: 'delete_client.php',
      method: 'POST',
      data: { id: id },
      success: function(res){
        leads = leads.filter(l => l.id != id);
        renderTable();
        alert('Lead deleted successfully.');
      },
      error: function(err){ console.error(err); alert('Delete failed.'); }
    });
  }

  // Save Add/Edit Lead
  $('#save-lead-form').click(function(){
    var editingId = $('#leadModal').data('editingId');
    var formData = new FormData();
    formData.append('client_name', $('#client_name').val());
    formData.append('company_name', $('#company_name').val());
    formData.append('mobile', $('#mobile').val());
    formData.append('alt_mobile', $('#alt_mobile').val());
    formData.append('email', $('#client_email').val());
    formData.append('total_price', $('#total_price').val());
    formData.append('initial_pay', $('#initial_pay').val());
    formData.append('pending_pay', $('#pending_pay').val());
    formData.append('term_plan', $('#term_plan').val());
    formData.append('project_start_date', $('#project_start_date').val());
    formData.append('project_end_date', $('#project_end_date').val());
    formData.append('assigned_to', $('#assigned_to').val());
    formData.append('stage', $('#stage').val());
    formData.append('duration', $('#duration').val());
    formData.append('deal_agent_id', '<?php echo $_SESSION['user_id']; ?>');

    formData.append('business_type', $('#business_type').val());
    formData.append('address', $('#address').val());
    formData.append('renewal_date', $('#renewal_date').val());
    formData.append('renewal_cost', $('#renewal_cost').val());
    formData.append('domain', $('#domain').val());
    formData.append('hosting', $('#hosting').val());
    formData.append('service', $('#service').val());
    if($('#contract_file')[0].files[0]) formData.append('contract_file', $('#contract_file')[0].files[0]);
    if(editingId) formData.append('id', editingId);

    $.ajax({
      url: editingId ? 'update_client.php' : 'add_client.php',
      method: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function(res){
        $('#leadModal').modal('hide');
        loadLeads();
        alert(editingId ? 'Lead updated.' : 'Lead added.');
      },
      error: function(err){ console.error(err); alert('Failed to save lead.'); }
    });
  });

  // Handle Action clicks
  $(document).on('click', '.action-item', function(){
    var action = $(this).data('action');
    var id = $(this).data('id');

    if(action === 'view') showViewModal(id);
    else if(action === 'edit') openEditModal(id);
    else if(action === 'delete') deleteLead(id);
  });

  // Open Add Modal
  $('#addDealBtn').click(function(){
    openEditModal(null);
  });

  // Initial load
  $(document).ready(function(){
    loadLeads();
  });
})();
</script>



</body>
</html>
