<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'connection.php';

/* Debug: confirm session */
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["error" => "Session expired"]);
    exit;
}

$user_id = $_SESSION['user_id'];
$role    = $_SESSION['role'] ?? 'Agent';

/* SQL */
$sql = "SELECT 
    sc.id,
    sc.client_id,
    sc.company_name,
    sc.client_name,
    sc.mobile,
    sc.alt_mobile,
    sc.client_email,
    sc.agent_id,
    sc.call_date,
    sc.business_type,
    sc.duration,
    sc.call_status,
    sc.follow_up_date,
    sc.meeting_schedule,
    sc.meeting_mode,
    sc.meeting_state,
    sc.client_done,
    sc.expected_closure,
    sc.proposal_contract,
    sc.proposal_file,
    sc.contract_file,
    sc.service,
    sc.remarks,
    u.name AS agent_text
FROM sales_calls sc
LEFT JOIN users u ON sc.agent_id = u.id";

$params = [];
$types  = "";

/* Role-based filter */
if ($role !== 'Admin') {
    $sql .= " WHERE sc.agent_id = ?";
    $types = "i";
    $params[] = $user_id;
}

$stmt = $con->prepare($sql);

if ($types) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$leads = $result->fetch_all(MYSQLI_ASSOC);

/* Normalize for JS */
foreach ($leads as &$l) {
    $l['meeting_schedule'] = !empty($l['meeting_schedule']); // bool
    $l['meeting_state']    = $l['meeting_state'] ?: 'Pending';
    $l['proposal_contract']= $l['proposal_contract'] ?: 'None';

    foreach ($l as $k => $v) {
        if ($v === null) $l[$k] = "";
    }
}

echo json_encode($leads);
