<?php
session_start();
include 'connection.php'; // mysqli connection

// -------------------
// Get POST data
// -------------------
$id = $_POST['id'] ?? null;
$client_id = $_POST['client_id'] ?? null;
$company_name = $_POST['company_name'] ?? '';
$client_name = $_POST['client_name'] ?? '';
$mobile = $_POST['mobile'] ?? '';
$alt_mobile = $_POST['alt_mobile'] ?? '';
$client_email = $_POST['client_email'] ?? '';
$agent_id = ($_SESSION['role'] === 'Admin')
    ? ($_POST['deal_agent_id'] ?? $_SESSION['user_id'])
    : $_SESSION['user_id'];

$call_date = $_POST['call_date'] ?? null;
$business_type = $_POST['business_type'] ?? '';
$duration_map = ["1 Month"=>1, "6 Months"=>6, "1 Year"=>12];
$duration = $duration_map[$_POST['duration']] ?? 1;
$call_status = $_POST['call_status'] ?? '';
$follow_up_date = $_POST['follow_up'] ?? null;
$meeting_schedule = ($_POST['meeting_schedule'] ?? '') === "Yes" ? date("Y-m-d H:i:s") : null;
$meeting_mode = $_POST['meeting_mode'] ?? '';
$meeting_state = $_POST['meeting_state'] ?? '';
$client_state = $_POST['client_state'] ?? 'Pending';
$expected_closure = $_POST['expected_closure'] ?? null;
$service = $_POST['service'] ?? '';
$remarks = $_POST['remarks'] ?? '';
$created_at = date("Y-m-d H:i:s");

// Proposal / Contract mapping
$proposal_status_map = ['Sent'=>'Proposal','Not Sent'=>'None'];
$proposal_contract = $_POST['proposal_status'] ?? 'Not Sent';
$proposal_contract = $proposal_status_map[$proposal_contract] ?? 'None';

// -------------------
// Handle file uploads
// -------------------
$proposal_file = null;
if(isset($_FILES['proposal_file']) && $_FILES['proposal_file']['tmp_name'] != ""){
    $target = "uploads/proposals/".time()."_".$_FILES['proposal_file']['name'];
    move_uploaded_file($_FILES['proposal_file']['tmp_name'], $target);
    $proposal_file = $target;
}

$contract_file = null;
if(isset($_FILES['contract_file']) && $_FILES['contract_file']['tmp_name'] != ""){
    $target = "uploads/contracts/".time()."_".$_FILES['contract_file']['name'];
    move_uploaded_file($_FILES['contract_file']['tmp_name'], $target);
    $contract_file = $target;
}

// -------------------
// Mandatory fields validation
// -------------------
if(empty($client_name) || empty($mobile)){
    echo json_encode(["status"=>"error","message"=>"Client Name and Mobile are required"]);
    exit;
}

// -------------------
// Ensure we have client_id
// -------------------
if(empty($client_id)){
    if(empty($company_name)) $company_name = 'Unknown Company';

    // Insert new client
    $stmt_client = $con->prepare("
        INSERT INTO clients 
        (company_name, client_name, mobile, alt_mobile, email, service, contract_file, created_at)
        VALUES (?,?,?,?,?,?,?,?)
    ");
    $stmt_client->bind_param(
        "ssssssss",
        $company_name,
        $client_name,
        $mobile,
        $alt_mobile,
        $client_email,
        $service,
        $contract_file,
        $created_at
    );

    if(!$stmt_client->execute()){
        echo json_encode(["status"=>"error","message"=>"Client insert failed: ".$stmt_client->error]);
        exit;
    }

    $client_id = $con->insert_id; // Get the newly inserted client ID
}

// -------------------
// Insert or Update sales_calls
// -------------------
if($id){ // UPDATE
    $stmt = $con->prepare("
        UPDATE sales_calls SET
            client_id=?, company_name=?, client_name=?, mobile=?, alt_mobile=?, client_email=?, agent_id=?,
            call_date=?, business_type=?, duration=?, call_status=?, follow_up_date=?, meeting_schedule=?,
            meeting_mode=?, meeting_state=?, client_done=?, expected_closure=?, proposal_contract=?, proposal_file=?,
            contract_file=?, service=?, remarks=?, created_at=?
        WHERE id=?
    ");
    $stmt->bind_param(
        "isssssississsssssssssssi",
        $client_id, $company_name, $client_name, $mobile, $alt_mobile, $client_email, $agent_id,
        $call_date, $business_type, $duration, $call_status, $follow_up_date, $meeting_schedule,
        $meeting_mode, $meeting_state, $client_state, $expected_closure, $proposal_contract, $proposal_file,
        $contract_file, $service, $remarks, $created_at,
        $id
    );
} else { // INSERT
    $stmt = $con->prepare("
        INSERT INTO sales_calls
        (client_id, company_name, client_name, mobile, alt_mobile, client_email, agent_id, call_date, business_type,
        duration, call_status, follow_up_date, meeting_schedule, meeting_mode, meeting_state, client_done, expected_closure,
        proposal_contract, proposal_file, contract_file, service, remarks, created_at)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
    ");
    $stmt->bind_param(
        "isssssississsssssssssss",
        $client_id, $company_name, $client_name, $mobile, $alt_mobile, $client_email, $agent_id,
        $call_date, $business_type, $duration, $call_status, $follow_up_date, $meeting_schedule,
        $meeting_mode, $meeting_state, $client_state, $expected_closure, $proposal_contract, $proposal_file,
        $contract_file, $service, $remarks, $created_at
    );
}

// -------------------
// Execute and return response
// -------------------
if($stmt->execute()){
    echo json_encode(["status"=>"success","message"=>"Deal saved successfully","client_id"=>$client_id]);
}else{
    echo json_encode(["status"=>"error","message"=>"Sales call insert/update failed: ".$stmt->error]);
}
?>
