<?php
require '../connection.php';
session_start();

header('Content-Type: application/json');

$response = ['status' => 'error', 'msg' => 'Invalid request'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!$email || !$password) {
        echo json_encode([
            'status' => 'error',
            'msg' => 'Email and password are required!'
        ]);
        exit;
    }

    // Fetch user by email
    $stmt = $con->prepare("SELECT id, name, email, password, role, status FROM users WHERE email = ? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo json_encode([
            'status' => 'error',
            'msg' => 'Email not registered!'
        ]);
        exit;
    }

    $user = $result->fetch_assoc();

    if ($user['status'] != 1) {
        echo json_encode([
            'status' => 'error',
            'msg' => 'Account is inactive. Contact admin!'
        ]);
        exit;
    }

    if (!password_verify($password, $user['password'])) {
        echo json_encode([
            'status' => 'error',
            'msg' => 'Invalid password!'
        ]);
        exit;
    }

    // ✅ LOGIN SUCCESS
    $_SESSION['user_id']    = $user['id'];
    $_SESSION['user_name']  = $user['name'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['role']       = $user['role'];

    echo json_encode([
        'status' => 'success',
        'msg' => 'Login successful! Redirecting...'
    ]);
    exit;
}

echo json_encode($response);
