<?php
// Enable error reporting for debugging (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../connection.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'msg' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Collect and trim input
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name  = trim($_POST['last_name'] ?? '');
    $email      = trim($_POST['email'] ?? '');
    $mobile     = trim($_POST['mobile'] ?? '');
    $password   = $_POST['password'] ?? '';
    $confirm    = $_POST['confirm_password'] ?? '';

    // Validate required fields
    if (!$first_name || !$last_name || !$email || !$password || !$confirm) {
        $response['msg'] = "All fields are required!";
        echo json_encode($response);
        exit;
    }

    // Check password match
    if ($password !== $confirm) {
        $response['msg'] = "Passwords do not match!";
        echo json_encode($response);
        exit;
    }

    // Check duplicate email
    $stmt = $con->prepare("SELECT id FROM users WHERE email=?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        $response['msg'] = "Email already registered!";
        echo json_encode($response);
        exit;
    }

    // Prepare data for insert
    $name = $first_name . ' ' . $last_name;
    $hashed_pass = password_hash($password, PASSWORD_DEFAULT);
    $role = 'Agent'; // default role
    $status = 1;     // active user

    // Correct INSERT with proper placeholders
    $stmt = $con->prepare("INSERT INTO users (name,email,mobile,password,role,status,created_at) VALUES (?,?,?,?,?,?,NOW())");
    $stmt->bind_param("sssssi", $name, $email, $mobile, $hashed_pass, $role, $status);

    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['msg'] = "Account created successfully!";
    } else {
        $response['msg'] = "Database error: " . $stmt->error;
    }

    echo json_encode($response);
    exit;
}

// fallback
echo json_encode($response);
