<?php
require 'connection.php';

$data = $_POST;
$id = intval($data['id'] ?? 0);

if (!$id) {
    exit(json_encode(['status' => 'error', 'msg' => 'ID missing']));
}

// Handle contract file upload
$contract_file = '';
if (isset($_FILES['contract_file']) && !empty($_FILES['contract_file']['name'])) {
    $target_dir = "uploads/";
    $contract_file = time() . '_' . basename($_FILES['contract_file']['name']);
    if (!move_uploaded_file($_FILES['contract_file']['tmp_name'], $target_dir . $contract_file)) {
        exit(json_encode(['status' => 'error', 'msg' => 'Failed to upload contract file']));
    }
}

// Columns to update and mapping POST keys to DB columns
$columns = [
    'company_name' => 'company_name',
    'client_name' => 'client_name',
    'mobile' => 'mobile',
    'alt_mobile' => 'alt_mobile',
    'email' => 'email',
    'address' => 'address',
    'total_price' => 'total_price',
    'initial_pay' => 'initial_pay',
    'pending_pay' => 'pending_pay',
    'term_plan' => 'term_plan',
    'project_start_date' => 'project_start_date',
    'project_end_date' => 'project_end_date',
    'stage' => 'stage',
    'assigned_to' => 'assigned_to',   // ✅ NOW MATCHES DB
    'renewal_date' => 'renewal_date',
    'renewal_cost' => 'renewal_cost',
    'domain' => 'domain',
    'hosting' => 'hosting',
    'service' => 'service',
    'business_type' => 'business_type',
    'duration' => 'duration',
    'agent_id' => 'deal_agent_id'
];


// Include contract_file if uploaded
if ($contract_file) {
    $columns['contract_file'] = 'contract_file';
}

// Build SET clause
$set_clause = implode(" = ?, ", array_keys($columns)) . " = ?";

// Prepare statement
$sql = "UPDATE clients SET $set_clause WHERE id = ?";
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    exit(json_encode(['status' => 'error', 'msg' => mysqli_error($con)]));
}

// Bind parameters dynamically
$types = '';
$values = [];
foreach ($columns as $db_col => $post_key) {
    if ($db_col === 'agent_id') {
        $values[] = intval($data[$post_key] ?? 0);
        $types .= 'i';
    } elseif (in_array($db_col, ['total_price','initial_pay','pending_pay','renewal_cost'])) {
        $values[] = isset($data[$post_key]) ? (float)$data[$post_key] : 0.0;
        $types .= 'd'; // decimal
    } elseif ($db_col === 'contract_file') {
        $values[] = $contract_file;
        $types .= 's';
    } else {
        $values[] = $data[$post_key] ?? '';
        $types .= 's';
    }
}

// Add ID at end
$values[] = $id;
$types .= 'i';

// Bind using references
$params = [];
$params[] = & $types;
foreach ($values as $key => $val) {
    $params[] = & $values[$key];
}

call_user_func_array([$stmt, 'bind_param'], $params);

// Execute
if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'msg' => mysqli_stmt_error($stmt)]);
}
?>
